@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li class="active-page"><a href="{{ url($url) }}">{{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <!-- <div class="section-header">
                    <h2>Table with simple header <code>.matmix-dt</code></h2>
                    <p>
                        This table is well styled and included edit delete options. You can use it in any table and this table support all bootstrap table classes like<code>.table, .table-striped, .table-hover, .table-bordered</code>
                    </p>
                </div> -->
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data {{ $title }}</h4>
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            <div class="row">
                                <div class="col-md-4">
                                    <?php 
                                        
                                        $daterange = (isset($_GET['daterange']))?$_GET['daterange']:date('Y-m-d H:m',strtotime('-1 Month')).' - '.date('Y-m-d H:m');
                                        // $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                                        // $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                                        
                                     ?>
                                    <a href="{{ url($url.'/cetak?type=html&menu='.$_GET['menu'].'&daterange='.$daterange) }}" target="_blank"><img src="{{ asset('images/btn_print2.png') }}" height="18" border="0" title="Cetak ke Format HTML"/></a>
                                    | <a class="btn btn-default" href="{{ url($url.'/cetak?type=excel&menu='.$_GET['menu'].'&daterange='.$daterange) }}" target="_blank">Export ke Excel</a>  | <a href="{{ url($url) }}" class="btn btn-sm btn-warning">Kembali</a>
                                </div>
                                <div class="col-md-8">
                                    <form class="form-horizontal">
                                        <input type="hidden"  value="<?php echo (isset($_GET['s']))?$_GET['s']:''; ?>">
                                        <input type="hidden" name="menu" value="{{ $_GET['menu'] }}">
                                        <div class="form-group">
                                            
                                            <div class=" col-md-5">
                                                <input type="text" class="form-control input-daterange-timepicker" name="daterange" value="{{ $daterange }}"/>
                                            </div>
                                            
                                            <!-- user -->
                                            <div class="col-md-3">
                                                <select name="user_id" class="form-control">
                                                    <option value="">All</option>
                                                    @foreach ($seconds as $data)
                                                        <option value="{{$data->id}}" 
                                                                @if (isset($_GET['user_id']) && $_GET['user_id'] == $data->id)
                                                                    selected
                                                                @endif
                                                            >{{$data->name}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            
                                            <div class="col-md-4">
                                                <button class="btn btn-info">Tampil</button>
                                            </div>


                                        </div>


                                    </form>
                                </div>
                            </div>
                            <div class="table-responsive">
                                
                                <table class="table table-striped table-hover table-bordered matmix-dt" id="tabel-barang-periode">
                                    <thead>
                                        <tr>
                                       
                                            <th>
                                                No
                                            </th>
                                           
                                            <th>
                                                Nama
                                            </th>
                                          
                                           <th>
                                               No Nota
                                           </th>
                                           <th>
                                               Tgl & Jam Penjualan
                                           </th>
                                            <th>
                                               Kode Barcode
                                           </th>
                                           <th>
                                               Barang
                                           </th>
                                           <th>
                                               Qty
                                           </th>
                                           <th>
                                               Total
                                           </th>   
                                           <th>
                                               Laba
                                           </th>                                           
                                         
                                         
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                        <?php $no = 1; ?>
                                        <?php 
                                            $page = 0;
                                            if(isset($_GET['page']) && $_GET['page'] > 1){
                                                $page = $_GET['page']*10-10;
                                            }
                                            $no = 1*$page+1; 
                                            $ttl_p = 0;
                                            $ttl_l = 0;
                                        ?>
                                        
                                        @foreach($datas as $data)
                                            <?php 
                                                $ttl_p += $data->jumlah* @$data->harga_barang->harga_jual - $data->diskon;
                                                $hargaDiskon= @$data->harga_barang->harga_jual - $data->diskon;
                                                $ttl_l += (@$data->harga_barang->harga_jual - @$data->harga_barang->harga_beli) * $data->jumlah - $data->diskon;
                                             ?>
                                            <tr>
                                                <td>
                                                    {{ $no++ }}
                                                </td>
                                                <td>
                                                    {{ @$data->penjualan->user->name }}
                                                </td>
                                                <td>
                                                    {{ @$data->penjualan->no_penjualan }}
                                                </td>
                                                <td>
                                                    {{ @$data->penjualan->created_at }}
                                                </td>
                                                <td>
                                                    {{ @$data->harga_barang->barang->kd_barang}}
                                                </td>
                                                <td>
                                                    {{ @$data->harga_barang->barang->nm_barang }} / {{ number_format(@$data->harga_barang->harga_jual) }}
                                                </td>
                                                <td>
                                                    {{ $data->jumlah }}
                                                </td>
                                                 <td>Rp.{{ number_format($data->jumlah * $data->harga_barang->harga_jual - $data->diskon) }}</td>                                                 

                                                <td>Rp.{{ number_format(($data->harga_barang->harga_jual - $data->harga_barang->harga_beli) * $data->jumlah - $data->diskon )  }}</td>                                                               
                                            </tr>
                                        @endforeach
                                        
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="7">
                                                
                                            </td>
                                            <td>
                                                Total Penjualan
                                            </td>
                                            <td>
                                                Total Laba
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="7">
                                                
                                            </td>
                                            <td>
                                                {{ number_format($ttl_p) }}
                                            </td>
                                            <td>
                                                {{ number_format($ttl_l) }}
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>

        </div>
        
    </div>
</div>


@endsection

@push('scripts')
    <script type="text/javascript">
        jQuery('.input-daterange-timepicker').daterangepicker({
            timePicker: true,
            locale: {
                format: 'YYYY-MM-DD HH:mm'
            },
            timePickerIncrement: 30,
            timePicker24Hour: true,
            timePickerSeconds: false
        });


    </script>


@endpush
