# Tata Cara Berkontribusi
Kami **menerima segala kontribusi** dan semua kontribusi akan **dikredit sepenuhnya**.

Mohon untuk membaca dan memahami tata cara kontribusi berikut sebelum membuat _issue_ atau mengajukan _pull request_.

## Prosedur
Sebelum membuat _issue_:
- Coba untuk mereplikasi problemnya, untuk memastikan kendala yang ditemukan tidak terjadi secara kebetulan.
- Cek dan pastikan fitur yang ingin Anda ajukan belum tersedia dalam proyek ini.
- Cek _pull request_ untuk memastikan _bug_ yang Anda temukan belum memiliki perbaikan yang sedang dalam proses.
- Cek _pull request_ untuk memastikan fitur yang ingin Anda ajukan tidak sedang dalam proses.

Sebelum mengajukan _pull request_:
- Cek basis kode proyek untuk memastikan fitur yang akan Anda ajukan belum tersedia dalam proyek ini.
- Cek _pull request_ untuk memastikan orang lain belum mengajukan fitur atau perbaikan yang sama dengan yang Anda lakukan lebih dulu.

## Syarat
- **Gunakan [standar kode PSR-2](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md)** - Gunakan [PHP Coding Standards Fixer](https://github.com/FriendsOfPHP/PHP-CS-Fixer) untuk memformat koding Anda ke PSR-2 dengan mudah.

- **Tambahkan pengujian untuk fitur baru** - Pengajuan fitur baru yang dilengkapi dengan pengujian akan lebih cepat diterima, karena memudahkan proses _review_.

- **Dokumentasikan semau perubahan yang terjadi** - Pastikan berkas `README.md` dan dokumentasi lain yang terkait sudah diperbarui.

- **Satu _pull request_ per fitur** - Jika Anda ingin melakukan lebih dari satu hal, pisah menjadi beberapa _pull request_.

- **Gunakan pesan _commit_ yang jelas** - Pastikan setiap _commit_ dalam _pull request_ Anda memiliki arti yang mudah dipahami.

-*Happy coding!**
