<?php $__env->startSection('content'); ?>
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="<?php echo e(url('backup')); ?>">Backup Database</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">Backup</a>
                                </li>
                                <li class="active-page"><a href="<?php echo e(url('backup')); ?>">Backup Database</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <!-- <div class="section-header">
                    <h2>Table with simple header <code>.matmix-dt</code></h2>
                    <p>
                        This table is well styled and included edit delete options. You can use it in any table and this table support all bootstrap table classes like<code>.table, .table-striped, .table-hover, .table-bordered</code>
                    </p>
                </div> -->
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data Backup Database</h4>
                        <div class="pull-right" style="padding: 10px;">
                           
                            <a id="create-new-backup-button" href="<?php echo e(url('backup/create')); ?>" class="btn btn-primary pull-right"
                               style="margin-bottom:2em;"><i
                                    class="fa fa-plus"></i> Create New Backup
                            </a>
                        </div>
                        
                    </div>

                    <?php 
                        use Spatie\Backup\Helpers\Format;
                        function humanFilesize($size, $precision = 2) {

                            $units = array('B','kB','MB','GB','TB','PB','EB','ZB','YB');
                            $step = 1024;
                            $i = 0;

                            while (($size / $step) > 0.9) {
                                $size = $size / $step;
                                $i++;
                            }
                            
                            return round($size, $precision).$units[$i];
                        } ?>
                    <div class="widget-container">
                        <div class="widget-block">
                           
                            <div class="table-responsive">
                                
                                <?php if(count($backups)): ?>

                                <table class="table table-striped table-bordered matmix-dt" id="example1">
                                    <thead>
                                    <tr>
                                        <th>File</th>
                                        <th>Size</th>
                                        <th>Waktu Di Buat</th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $backups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $backup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($backup['file_name']); ?></td>
                                            <td><?php echo e(Format::humanReadableSize($backup['file_size'])); ?></td>
                                            <td><?php echo e($backup['time']->format('Y-m-d H:i:s')); ?></td>
                                            <td class="text-right">
                                                <a class="btn btn-xs btn-default"
                                                   href="<?php echo e(url('backup/download/'.$backup['file_name'])); ?>"><i
                                                        class="fa fa-cloud-download"></i> Download</a>
                                                <!-- <a class="btn btn-xs btn-info"
                                                   href="<?php echo e(url('backup/restore/'.$backup['file_name'])); ?>"><i
                                                        class="fa fa-cloud-download"></i> Restore</a> -->
                                                <!-- <a class="btn btn-xs btn-danger" data-button-type="delete"
                                                   href="<?php echo e(url('backup/delete/'.$backup['file_name'])); ?>"><i class="fa fa-trash-o"></i>
                                                    Delete</a> -->
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            <?php else: ?>
                                <div class="well">
                                    <h4>There are no backups</h4>
                                </div>
                            <?php endif; ?>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>

        </div>
        
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\laravel\hawa\laravel\resources\views/backup/backups.blade.php ENDPATH**/ ?>