<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect('login');
});

Auth::routes();

Route::group(['middleware' => ['auth']] , function(){

	Route::get('backup', 'BackupController@index');
	Route::get('backup/create', 'BackupController@create');
	Route::get('backup/download/{file_name}', 'BackupController@download');
	Route::get('backup/delete/{file_name}', 'BackupController@delete');
	
	Route::group(['prefix' =>  'api'], function(){
		Route::get('barang','BarangController@get_data');
		Route::get('harga_barang/{kd}','BarangController@get_harga');
		Route::get('cari_barang/{barcode}','BarangController@cari_barang');
		Route::get('cek_harga/{kd}/{jb}','BarangController@cek_harga');
		Route::get('kota','PelangganController@kota');
	});

	//excel
	Route::get('barang/import','BarangController@importExportView');
	Route::post('barang/import','BarangController@import');
	Route::get('barang/export','BarangController@export');

	Route::get('pelanggan/import','PelangganController@importExportView');
	Route::post('pelanggan/import','PelangganController@import');
	Route::get('pelanggan/export','PelangganController@export');

	Route::get('supplier/import','SupplierController@importExportView');
	Route::post('supplier/import','SupplierController@import');
	Route::get('supplier/export','SupplierController@export');


	Route::get('/home', 'HomeController@index')->name('home');

	Route::get('/pelanggan/deleteAll', 'PelangganController@deleteAll');
	Route::resource('/pelanggan', 'PelangganController');

	Route::get('/supplier/deleteAll', 'SupplierController@deleteAll');
	Route::resource('/supplier', 'SupplierController');

	Route::get('/merek/deleteAll', 'MerekController@deleteAll');
	Route::resource('/merek', 'MerekController');

	Route::get('/kategori/deleteAll', 'KategoriController@deleteAll');
	Route::resource('/kategori', 'KategoriController');

	Route::get('/jenis/deleteAll', 'JenisController@deleteAll');
	Route::resource('/jenis', 'JenisController');

	
	
	Route::get('/barang/{kd}/barcode', 'BarangController@barcode');
	Route::get('/barang/barcodeAll', 'BarangController@barcodeAll');
	Route::get('/barang/deleteAll', 'BarangController@deleteAll');
	Route::resource('/barang', 'BarangController');


	Route::get('/satuan/deleteAll', 'SatuanController@deleteAll');
	Route::resource('/satuan', 'SatuanController');


	Route::get('/level/deleteAll', 'LevelController@deleteAll');
	Route::resource('/level', 'LevelController');

	Route::get('/pembelian/{id}/cetak', 'PembelianController@cetak');
	Route::get('/pembelian/deleteAll', 'PembelianController@deleteAll');
	Route::resource('/pembelian', 'PembelianController');


	Route::get('/penjualan/{id}/cetak', 'PenjualanController@cetak');
	Route::get('/penjualan/{id}/cetak-thermal', 'PenjualanController@cetakThermal');
	Route::get('/penjualan/deleteAll', 'PenjualanController@deleteAll');
	Route::resource('/penjualan', 'PenjualanController');


	Route::get('/retur_pembelian/{id}/cetak', 'ReturPembelianController@cetak');
	Route::get('/retur_pembelian/deleteAll', 'ReturPembelianController@deleteAll');
	Route::resource('/retur_pembelian', 'ReturPembelianController');


	Route::get('/retur_penjualan/{id}/cetak', 'ReturPenjualanController@cetak');
	Route::get('/retur_penjualan/deleteAll', 'ReturPenjualanController@deleteAll');
	Route::resource('/retur_penjualan', 'ReturPenjualanController');

	Route::get('/pembayaran_hutang/deleteAll', 'BayarPembelianController@deleteAll');
	Route::resource('/pembayaran_hutang', 'BayarPembelianController');

	Route::get('/pembayaran_piutang/deleteAll', 'BayarPenjualanController@deleteAll');
	Route::resource('/pembayaran_piutang', 'BayarPenjualanController');

	Route::get('/laporan/{menu}/cetak', 'LaporanController@cetak');
	Route::resource('/laporan', 'LaporanController');


	Route::resource('/bonus', 'BonusController');
	Route::resource('/profil', 'ProfilController');

	Route::resource('/user', 'UserController');
	Route::post('/user/{id}/ubah_password', 'UserController@ubah_password');

	Route::get('user-log','UserLogController@index');
	Route::get('notifikasi','NotifikasiController@index');


	Route::get('/jasa/bayar', 'JasaController@bayarView');
	Route::get('/jasa/{no}/bayar', 'JasaController@bayarDetail');
	Route::post('/jasa/{no}/bayar', 'JasaController@bayar');
	Route::get('/bayar-jasa/{no}/cetak', 'JasaController@bayarCetak');
	Route::get('/jasa/{id}/cetak', 'JasaController@cetak');
	Route::resource('/jasa', 'JasaController');

	Route::resource('/paket', 'PaketController');

	Route::resource('/metode_bayar', 'MetodeBayarController');

	Route::get('/poin/{id}', 'PoinController@index');
	Route::post('/poin/{id}/store', 'PoinController@store');
});

