@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li  ><a href="{{ url($url) }}">{{ $title }}</a></li>
                                <li class="active-page" ><a href="{{ url($url) }}">Edit Data {{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data {{ $title }}</h4>
                        <div class="pull-right" style="padding: 10px;">
                           
                            <a href="{{ url($url) }}" class="btn  btn-warning ">Kembali</a>
                        </div>
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            <div class="row">
                                <div class="col-md-6">
                                   
                                    <form class="form-horizontal" method="post" action="{{ url($url.'/'.$data->id) }}">
                                        @csrf
                                        <input type="hidden" name="_method" value="PUT">
                             

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Nama</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control" name="name" placeholder="Nama" value="{{ $data->name }}">
                                                
                                            </div>
                                        </div>

                                        

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Level</label>
                                            <div class=" col-md-8">
                                                <select class="form-control select2" name="id_level">
                                                    <option value="">Pilih Level</option>

                                                    @foreach($levels as $level)
                                                        <option value="{{ $level->id }}" @if($data->level_id == $level->id) selected @endif>{{ $level->nm_level }}</option>
                                                    @endforeach
                                                </select>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">

                                            <label for="username" class="col-lg-4 control-label"></label>

                                            <div class="col-lg-3">

                                                <button type="button" class="btn btn-primary " data-toggle="modal" data-target="#myModal">Ubah Password</button>

                                            </div>

                                        </div>


                                      

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">&nbsp;</label>
                                            <div class="col-md-8">
                                                <div class="form-actions">
                                                    <button type="submit" class="btn btn-primary">Update</button>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </form>

                                    <div id="myModal" class="modal fade" role="dialog">
                                        <div class="modal-dialog modal-lg">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                    <h4 class="modal-title">Ubah Password</h4>
                                                </div>
                                                <div class="modal-body" style="padding:0;">
                                                    <form class="form-horizontal " method="POST" action="{{ url('user/'.$data->id.'/ubah_password') }}" enctype="multipart/form-data">
                                                        {{ csrf_field() }}
                                                        
                                                        <div class="form-group">
                                                            <label  class="col-lg-2 control-label">Password Lama</label>

                                                            <div class="col-lg-6">

                                                                <input type="password" name="password_lama" class="form-control" required  minlength="3">

                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label  class="col-lg-2 control-label">Password Baru</label>

                                                            <div class="col-lg-6">

                                                                <input type="password" name="password_baru" class="form-control" required  minlength="3">

                                                            </div>
                                                        </div>

                                                        <div class="form-group">
                                                            <label  class="col-lg-2 control-label"></label>

                                                            <div class="col-lg-6">

                                                                <input type="submit" name="submit" value="Ubah">

                                                            </div>
                                                        </div>
                                                        
                                                    </form>
                                                      
                                                    
                                                </div>
                                                <div class="modal-footer">
                                                   
                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                               
                            </div>
                        </div>
                    </div>
                </div>    
            </div>
                

        </div>
        
    </div>
</div>

@endsection
