@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li  ><a href="{{ url($url) }}">{{ $title }}</a></li>
                                <li class="active-page" ><a href="{{ url($url) }}">Detail Data {{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <form class="form-horizontal" method="post" action="{{ url($url.'/'.$data->no_retur_pembelian) }}">
            <div class="row">
                <div class="col-md-12">
                    <div class="box-widget widget-module">
                        <div class="widget-head clearfix">
                            <span class="h-icon"><i class="fa fa-table"></i></span>
                            <h4>Data {{ $title }}</h4>
                            <div class="pull-right" style="padding: 10px;">
                             
                                <a href="{{ url($url) }}" class="btn  btn-warning ">Kembali</a>
                            </div>
                            
                        </div>
                        <div class="widget-container">
                            <div class="widget-block">
                                <div class="row">
                                    
                                    <div class="col-md-6">
                                     
                                        
                                        @csrf
                                        <input type="hidden" name="_method" value="PUT">
                                        

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">No Retur Pembelian</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control" name="no_retur_pembelian" placeholder="No Retur Pembelian" readonly="" value="{{ $data->no_retur_pembelian }}" readonly="" disabled="">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Tanggal Retur Pembelian</label>
                                            <div class=" col-md-8">
                                                <input type="date" class="form-control" name="tgl_retur_pembelian" value="{{ $data->tgl_retur_pembelian }}" readonly="" disabled="">
                                                
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Pilih Supplier</label>
                                            <div class=" col-md-8">
                                                <select class="form-control" required="" name="kd_supplier" readonly="" disabled="">
                                                    <option>Pilih Supplier</option>
                                                    @foreach($suppliers as $supplier)
                                                    <option value="{{ $supplier->kd_supplier }}" @if($supplier->kd_supplier == $data->kd_supplier) selected @endif>{{ $supplier->nm_supplier }}</option>
                                                    @endforeach
                                                </select>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Keterangan</label>
                                            <div class=" col-md-8">
                                                <textarea class="form-control" name="keterangan" readonly="" disabled="">{{ $data->keterangan }}</textarea>
                                                
                                            </div>
                                        </div>

                                        
                                        
                                    </div>

                                  
                                    
                                </div>
                            </div>
                        </div>
                    </div>    
                </div>
                

            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="box-widget widget-module">
                        <div class="widget-head clearfix">
                            <span class="h-icon"><i class="fa fa-table"></i></span>
                            <h4>Detail {{ $title }}</h4>
                            
                        </div>
                        <div class="widget-container">
                            <div class="widget-block">
                                <div id="list-contain">
                                    
                                    <table class="table table-striped table-responsive"  style="margin-top: -10px;" width="800" border="0" cellspacing="1" cellpadding="2">
                                        <tr>
                                            <td width="23" ><strong>No</strong></td>
                                              <td width="70" ><strong>Kode</strong></td>
                                              <td width="390" ><strong>Nama Barang </strong></td>
                                              <td width="199"><strong>Keterangan Barang </strong></td>
                                              <td width="48" align="right" ><strong>Jumlah</strong></td>
                                             
                                        </tr>
                                    <?php $no = 0;$jumlahbarang = 0; ?>
                                    @foreach($data->detail as $dd)
                                        <?php
                               
                                            $no++;
                                            $id             = $dd->id;
                                            $jumlahbarang   = $jumlahbarang + $dd->jumlah;
                                        ?>
                                            <tr>
                                              <td><?php echo $no; ?></td>
                                              <td><?php echo $dd->harga_barang->barang->kd_barang; ?></b></td>
                                              <td><?php echo $dd->harga_barang->barang->nm_barang; ?></td>
                                              <td><?php echo $dd->keterangan; ?></td>
                                              <td align="right"><?php echo $dd->jumlah; ?></td>
                                          
                                            </tr>
                                    <?php $no++ ?>
                                    @endforeach
                                    
                                    
                                    <tr>
                                      <td colspan="4" align="right" bgcolor="#F5F5F5"><strong>TOTAL BARANG : </strong></td>
                                      <td align="right" bgcolor="#F5F5F5"><b><?php echo $jumlahbarang; ?></b></td>
                                     
                                    </tr>
                                    <tr>
                                        <td colspan="4">&nbsp;</td>
                                        <td >
                                            <a href="{{ url($url.'/'.$data->no_retur_pembelian.'/cetak') }}" class="btn btn-primary btn-sm" target="_blank" style="cursor:pointer;">Cetak</a>
                                        </td>
                                     
                                    </tr>
                                  </table>
                                
                            </div>
                        </div>
                    </div>    
                </div>
                

            </div>
        </form>
        
    </div>
</div>


@endsection
