@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li  ><a href="{{ url($url) }}">{{ $title }}</a></li>
                                <li class="active-page" ><a href="{{ url($url) }}">Tambah Data {{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <form class="form-horizontal" method="post" action="{{ url($url) }}">
            <div class="row">
                <div class="col-md-12">
                    <div class="box-widget widget-module">
                        <div class="widget-head clearfix">
                            <span class="h-icon"><i class="fa fa-table"></i></span>
                            <h4>Data {{ $title }}</h4>
                            <div class="pull-right" style="padding: 10px;">
                             
                                <a href="{{ url($url) }}" class="btn  btn-warning ">Kembali</a>
                            </div>
                            
                        </div>
                        <div class="widget-container">
                            <div class="widget-block">
                                <div class="row">
                                    
                                    <div class="col-md-6">
                                     
                                        
                                        @csrf

                                        

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">No Retur Pembelian</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control" name="no_retur_pembelian" placeholder="No Retur Pembelian" readonly="" value="{{ ++$kd }}">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Tanggal Retur Pembelian</label>
                                            <div class=" col-md-8">
                                                <input type="date" class="form-control" name="tgl_retur_pembelian" value="{{ date('Y-m-d') }}">
                                                
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Pilih Supplier</label>
                                            <div class=" col-md-8">
                                                <select class="form-control" required="" name="kd_supplier" required>
                                                    <option value="">Pilih Supplier</option>
                                                    @foreach($suppliers as $supplier)
                                                    <option value="{{ $supplier->kd_supplier }}">{{ $supplier->nm_supplier }}</option>
                                                    @endforeach
                                                </select>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Keterangan</label>
                                            <div class=" col-md-8">
                                                <textarea class="form-control" name="keterangan" required></textarea>
                                                
                                            </div>
                                        </div>

                                        
                                        
                                    </div>

                                  
                                    
                                </div>
                            </div>
                        </div>
                    </div>    
                </div>
                

            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="box-widget widget-module">
                        <div class="widget-head clearfix">
                            <span class="h-icon"><i class="fa fa-table"></i></span>
                            <h4>Detail {{ $title }}</h4>
                            
                        </div>
                        <div class="widget-container">
                            <div class="widget-block">
                                <div id="list-contain">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label>Barang</label>
                                        </div>
                                        <div class="col-md-2">
                                            <label>Jumlah</label>
                                        </div>

                                       

                                        <div class="col-md-3">
                                            <label>Keterangan</label>
                                        </div>

                                        <div class="col-md-2">
                                            <label>Harga</label>
                                        </div>
                                   

                                      
                                    </div>
                                    

                                    <div class="row list-harga" id="list-harga-0" data-harga="0">
                                        <div class="col-md-3">
                                            <div class="input-group ex-margin">
                                                <input type="text" class="form-control nama" placeholder="Pilih Barang" readonly>
                                                <span class="input-group-btn">
                                                <button class="btn btn-success pilih-barang" type="button" data-toggle="modal" data-target="#pilihBarang" data-id="list-harga-0" data-kode="kode-0">Pilih Barang</button>
                                                <input type="hidden" name="id_harga_barang[]" class="kode">
                                                </span>
                                            </div>
                                            
                                        </div>

                                        <div class="col-md-2">
                                            <div class="form-group">
                                                
                                                <div class=" col-md-12">
                                                    <input type="number" name="jumlah[]" class="form-control jumlah jumlahnya" min="1" value="1" onkeyup="get_total()" onchange="get_total()">
                                                    
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-3">
                                            <div class="form-group">
                                            
                                                <div class=" col-md-12">
                                                    <textarea class="form-control" name="keterangan_detail[]" required></textarea>
                                                    
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-2">
                                            <div class="form-group">
                                                
                                                <div class=" col-md-12">
                                                    <strong class="harga">Rp.0</strong>
                                                    
                                                </div>
                                            </div>
                                        </div>


                                        <div class="col-md-1">
                                            <div class="form-group">
                                                
                                                <div class=" col-md-12">
                                                    <!-- <button type="button" data-id="list-harga-1" class="delete_row">X</button> -->
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="col-md-3">
                                            <strong>Total</strong>
                                        </div>
                                        <div class="col-md-2" >
                                            <label id="total_jumlah">0</label>
                                        </div>

                                        <div class="col-md-3">
                                            
                                        </div>

                                        <div class="col-md-2" >
                                            <label id="total_harga">Rp.0</label>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <br>
                                <div class="row">
                                    
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            
                                            <div class="col-md-12">
                                                <div class="form-actions">
                                                    <button type="button" class="btn btn-default" id="add_row">Add List</button>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            
                                            <div class="col-md-12">
                                                <div class="form-actions">
                                                    <button type="submit" class="btn btn-primary">Tambah</button>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    
                                    
                                </div>
                            </div>
                        </div>
                    </div>    
                </div>
                

            </div>
        </form>
        
    </div>
</div>

<div class="row " id="list-harga" style="display: none;" data-harga="0">
    <div class="col-md-3">
        <div class="input-group ex-margin">
            <input type="text" class="form-control nama" placeholder="Pilih Barang" readonly>
            <span class="input-group-btn">
            <button class="btn btn-success pilih-barang " type="button" data-toggle="modal" data-target="#pilihBarang" data-id="list-harga">Pilih Barang</button>
            <input type="hidden" name="id_harga_barang[]" class="kode">
            </span>
        </div>
        
    </div>

    <div class="col-md-2">
        <div class="form-group">
            
            <div class=" col-md-12">
                <input type="number" name="jumlah[]" class="form-control jumlah" required="" min="1" value="1" onkeyup="get_total()" onchange="get_total()">
                
            </div>
        </div>
    </div>



    <div class="col-md-3">
        <div class="form-group">
        
            <div class=" col-md-12">
                <textarea class="form-control" name="keterangan_detail[]"></textarea>
                
            </div>
        </div>
    </div>

    <div class="col-md-2">
        <div class="form-group">
            
            <div class=" col-md-12">
                <strong class="harga">Rp.0</strong>
                
            </div>
        </div>
    </div>



    <div class="col-md-1">
        <div class="form-group">
            
            <div class=" col-md-12">
                <button type="button" data-id="list-harga-1" class="delete_row" >X</button>
                
            </div>
        </div>
    </div>
</div>


<div id="pilihBarang" class="modal fade" role="dialog">
  <div class="modal-dialog modal-lg">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Barang</h4>
      </div>
      <div class="modal-body" >
        <div class="row">
            <div class="col-md-6">
            </div>
            <div class="col-md-6">
                <form class="form-horizontal" id="myForm">
                    <div class="form-group">
                        <label class="col-md-6 control-label">Search:</label>
                        <div class=" col-md-6">
                            <input class="form-control search" type="text" placeholder="Search" name="s" value="<?php echo (isset($_GET['s']))?$_GET['s']:''; ?>">
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="row" id="list-data">
            
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>

  </div>
</div>
<script src="{{ asset('js/app.js') }}"></script>
<script type="text/javascript">
    var cur_id ="list-harga-1";
    var total_jumlah = 0;
    var total_harga = 0;
    function get_total() {
        var j = $(".jumlahnya");
        var h = $(".list-harga");
        total_jumlah = 0;
        total_harga = 0;
        for (var i = 0; i < h.length; i++) {

            total_jumlah += parseInt($(".jumlahnya").eq(i).val());
            total_harga += parseInt($(".jumlahnya").eq(i).val()) * parseInt(h.eq(i).data('harga'));
        }
        $("#total_jumlah").html(parseInt(total_jumlah));

        $("#total_harga").html("Rp."+total_harga);

        // $("#uang_bayar").attr('min',total_harga);

    }
    jQuery(document).ready(function ($) {
		
		$(document).on('submit','#myForm',function(e){
			e.preventDefault();
		});
		
        $(document).on('click','.pilih-barang',function (e) {
            cur_id = $(this).data('id');
           
        });

        $(document).on('click','#add_row',function (e) {
            
            get_total();
        });

        
        $(document).on('click','.delete_row',function (e) {
             $("#"+$(this).data('id')).remove();
            
            get_total();
        });
        $(document).on('click','.terpilih',function (e) {
            $("#"+cur_id+" .kode").val($(this).data('kode'));
            $("#"+cur_id+" .nama").val($(this).data('nama'));
            // $("#"+cur_id+" .diskon").val($(this).data('diskon'));
            // $("#"+cur_id+" .jumlah").attr('min',$(this).data('stok'));
            $("#"+cur_id+" .harga").html("Rp."+$(this).data('harga'));
            $("#"+cur_id+" .delete_row").data("jumlah",$(this).data('stok'));
            $("#"+cur_id).data("harga",$(this).data('harga'));
            
            
            get_total();
        });


        
        


        var ss = "";
        $(document).on('click', '.pagination a',function(event)
        {
            event.preventDefault();
  
            $('li').removeClass('active');
            $(this).parent('li').addClass('active');
  
            var myurl = $(this).attr('href');
            var page=$(this).attr('href').split('page=')[1];
            
            get_data_barang(ss,page);
            
        });

        $(document).on('keyup', '.search',function(event)
        {
            
            get_data_barang($(this).val(),1);
            
        });

        $(document).on('click','.pilih-barang',function (e) {
            get_data_barang(ss,1);
        });

        function get_data_barang(s,p) {
            ss = s;
            $.ajax({
                url: '{{ url("api/barang") }}?page='+p+'&s='+s,
                type: 'GET',
                
                success: function (data) {
                    $("#list-data").html(data);
                    // $(".search")[0].focus();
                }
            });
        }
    });
    
</script>
@endsection
