@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li  ><a href="{{ url($url) }}">{{ $title }}</a></li>
                                <li class="active-page" ><a href="{{ url($url) }}">Ubah {{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data {{ $title }}</h4>
                      
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            <div class="row">
                                <div class="col-md-6">
                                   
                                    <form class="form-horizontal" method="post" action="{{ url($url) }}" enctype="multipart/form-data">
                                        @csrf

                             

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Nama</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control" name="nama" placeholder="Nama" value="{{ @$data->nama }}">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Alamat</label>
                                            <div class=" col-md-8">
                                                <textarea class="form-control" name="alamat">{{ @$data->alamat }}</textarea>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Kota</label>
                                            <div class=" col-md-8">
                                                <select class="form-control select2" name="kota" required>
                                                    @foreach($kota as $kotas)
                                                    <option value="{{$kotas->city_id}}" @if($data->city_id == $kotas->city_id) selected @endif>{{$kotas->title}}</option>
                                                    @endforeach
                                                </select>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">No Telepon</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control" name="no_telepon" placeholder="No Telepon" value="{{ @$data->no_telepon }}">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Keterangan Bawah Nota</label>
                                            <div class=" col-md-8">
                                                <textarea class="form-control" name="keterangan">{{ @$data->keterangan }}</textarea>
                                                
                                            </div>
                                        </div>

                                     

                                        <div class="form-group">
                                            <label class="col-md-4 control-label"></label>
                                            <div class=" col-md-8">
                                                <img src="{{asset('images/'.Helper::logo())  }}" style="max-width: 20%;">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Logo</label>
                                            <div class=" col-md-8">
                                                <input type="file" name="logo" class="form-control">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label"></label>
                                            <div class=" col-md-8">
                                                <img src="{{asset('images/'.Helper::logo2())  }}" style="max-width: 70%;">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Logo 2</label>
                                            <div class=" col-md-8">
                                                <input type="file" name="logo2" class="form-control">
                                                
                                            </div>
                                        </div>



                                        <div class="form-group">
                                            <label class="col-md-4 control-label">&nbsp;</label>
                                            <div class="col-md-8">
                                                <div class="form-actions">
                                                    <button type="submit" class="btn btn-primary">Update</button>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </form>
                                </div>
                               
                            </div>
                        </div>
                    </div>
                </div>    
            </div>
                

        </div>
        
    </div>
</div>

@endsection
