@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">Transaksi</a>
                                </li>
                                <li class="active-page"><a href="{{ url($url) }}">{{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <!-- <div class="section-header">
                    <h2>Table with simple header <code>.matmix-dt</code></h2>
                    <p>
                        This table is well styled and included edit delete options. You can use it in any table and this table support all bootstrap table classes like<code>.table, .table-striped, .table-hover, .table-bordered</code>
                    </p>
                </div> -->
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data {{ $title }}</h4>
                        <div class="pull-right" style="padding: 10px;">
                           
                            <a href="{{ url($url.'/create') }}" class="btn  btn-info ">Tambah Data</a>
                        </div>
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            
                            <div class="row" style="margin-bottom: 10px;">

                                <div class="col-md-12">
                                    <form class="form-horizontal">
                                        @if(isset($_GET['menu']))
                                            <input type="hidden" name="menu" value="{{ $_GET['menu'] }}">
                                        @endif
                                        <div class=" col-md-3">
                                            <input class="form-control" type="text" placeholder="Cari " name="s" value="<?php echo (isset($_GET['s']))?$_GET['s']:''; ?>">
                                        </div>

                                        <div class=" col-md-3">
                                            <input type="date" name="from" class="form-control" placeholder="Dari Tanggal" value="{{ $from }}" required>
                                        </div>
                                        <div class=" col-md-3">
                                            <input type="date" name="to" class="form-control" placeholder="Sampai Tanggal" value="{{ $to }}" required>
                                        </div>
                                        
                                        <div class="col-md-1">
                                            <button class="btn btn-primary">Filter</button>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <button style="margin-bottom: 10px" class="btn btn-danger delete_all" data-url="{{ url($url.'/deleteAll') }}">Delete All Selected</button>
                                <table class="table table-striped table-hover table-bordered matmix-dt">
                                    <thead>
                                        <tr>
                                            <th class="tc-center">
                                                <input type="checkbox"  id="master">
                                            </th>
                                            <th>
                                                No
                                            </th>
                                           
                                            <th>
                                                No Nota
                                            </th>
                                            <th>
                                                Tanggal Penjualan
                                            </th>
                                            <th>
                                                Keterangan
                                            </th>
                                            <th>
                                                Barang
                                            </th>
                                
                                            <th class="tc-center">
                                                Aksi
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($datas as $data)
                                        <?php
                                            $total_penjualan = 0;
                                            $total_jumlah = 0;
                                        ?>
                                            <tr>
                                                <td class="tc-center">
                                                    <input type="checkbox" class=" sub_chk" data-id="{{$data->no_penjualan}}">
                                                </td>
                                                <td>
                                                    {{ $no++ }}
                                                </td>
                                                
                                                <td>
                                                    {{ $data->no_penjualan }}
                                                </td>

                                                <td>
                                                    {{ $data->tgl_penjualan }}
                                                </td>
                                                

                                                <td>
                                                    {{ $data->keterangan }}
                                                </td>
                                                <td>
                                                    <table class="table">
                                                        
                                                        
                                                        @foreach($data->detail as $detail)
                                                        <?php
                                                            $harga_diskon = $detail->jumlah * $detail->harga_barang->harga_jual - $detail->diskon;
                                                            $total_penjualan += $harga_diskon;
                                                            $total_jumlah += $detail->jumlah;
                                                        ?>
                                                        <tr>
                                                            <td style="width: 50%">{{ $detail->harga_barang->barang->nm_barang }}</td>
                                                            <td>{{ $detail->harga_barang->barang->barcode }}</td>
                                                            <td>{{$detail->jumlah}} Pcs</td>
                                                            <td>Rp. {{ number_format($harga_diskon) }}</td>
                                                        </tr>
                                                            
                                                        @endforeach
                                                        <tr>
                                                            <td><b>Total</b></td>
                                                            <td></td>
                                                            <td><b>{{ $total_jumlah }} Pcs</b></td>
                                                            <td><b>Rp. {{number_format($total_penjualan)}}</b></td>
                                                        </tr>
                                                    </table>
                                                </td>

                                                <td class="tc-center">
                                                    <div class="btn-toolbar" role="toolbar">
                                                        <div class="btn-group" role="group">
                                                            <?php $link = url($url.'/'.$data->no_penjualan.'/cetak-thermal'); ?>
                                                            <a href="{{ $link }}" class="btn btn-warning btn-sm" target="_blank">Cetak Di Android</a>
                                                            <a href="{{ url($url.'/'.$data->no_penjualan.'/cetak') }}" class="btn btn-primary btn-sm" target="_blank" style="cursor:pointer;">Cetak</a>
                                                            <a href="{{ url($url.'/'.$data->no_penjualan) }}" class="btn btn-success btn-sm ">Detail</a>
                                                            <!-- <a href="{{ url($url.'/'.$data->no_penjualan.'/edit') }}" class="btn btn-warning btn-sm ">Edit</a> -->
                                                            <a href="#" class="btn btn-danger btn-sm m-user-delete" data-id="{{ $data->no_penjualan }}" data-url="{{ $url }}">Delete</a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="5" align="right">Total :</td>
                                            <td align="right"><b>Rp. {{ number_format($grand_total_penjualan) }}</b></td>
                                            <td></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <div class="dt-pagination">
                                <nav>
                                    {!! $datas->appends(request()->query())->links() !!}
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        
    </div>
</div>



@endsection
