@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li  ><a href="{{ url($url) }}">{{ $title }}</a></li>
                                <li class="active-page" ><a href="{{ url($url) }}">Edit Data {{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <form class="form-horizontal" method="post" action="{{ url($url.'/'.$data->no_pembelian) }}">
            <div class="row">
                <div class="col-md-12">
                    <div class="box-widget widget-module">
                        <div class="widget-head clearfix">
                            <span class="h-icon"><i class="fa fa-table"></i></span>
                            <h4>Data {{ $title }}</h4>
                            <div class="pull-right" style="padding: 10px;">
                             
                                <a href="{{ url($url) }}" class="btn  btn-warning ">Kembali</a>
                            </div>
                            
                        </div>
                        <div class="widget-container">
                            <div class="widget-block">
                                <div class="row">
                                    
                                    <div class="col-md-6">
                                     
                                        
                                        @csrf
                                        <input type="hidden" name="_method" value="PUT">
                                        

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">No Pembelian</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control" name="no_pembelian" placeholder="No Pembelian" readonly="" value="{{ $data->no_pembelian }}">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Tanggal Pembelian</label>
                                            <div class=" col-md-8">
                                                <input type="date" class="form-control" name="tgl_pembelian" value="{{ $data->tgl_pembelian}}">
                                                
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Pilih Supplier</label>
                                            <div class=" col-md-8">
                                                <select class="form-control select2" required="" name="kd_supplier">
                                                    <option>Pilih Supplier</option>
                                                    @foreach($suppliers as $supplier)
                                                    <option value="{{ $supplier->kd_supplier }}" @if($supplier->kd_supplier == $data->kd_supplier) selected @endif>{{ $supplier->nm_supplier }}</option>
                                                    @endforeach
                                                </select>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Keterangan</label>
                                            <div class=" col-md-8">
                                                <select class="form-control" required="" name="keterangan">
                                                    <option>Pilih Keterangan</option>
                                                    <option value="Cash" @if($data->keterangan == "Cash") selected @endif>Cash</option>
                                                    <option value="Kredit" @if($data->keterangan == "Kredit") selected @endif>Kredit</option>
                                                </select>
                                                
                                            </div>
                                        </div>

                                        
                                        
                                    </div>

                                  
                                    
                                </div>
                            </div>
                        </div>
                    </div>    
                </div>
                

            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="box-widget widget-module">
                        <div class="widget-head clearfix">
                            <span class="h-icon"><i class="fa fa-table"></i></span>
                            <h4>Detail {{ $title }}</h4>
                            
                        </div>
                        <div class="widget-container">
                            <div class="widget-block">
                                <div id="list-contain">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label>Barang</label>
                                        </div>
                                        <div class="col-md-2">
                                            <label>Jumlah</label>
                                        </div>

                                        <div class="col-md-2">
                                            <label>Diskon</label>
                                        </div>

                                        <div class="col-md-2">
                                            <label>Harga</label>
                                        </div>
                                   

                                      
                                    </div>
                                    <?php $no = 1; ?>
                                    @foreach($data->detail as $dd)
                                        <div class="row list-harga" id="list-harga-{{ $no }}" data-harga="{{ $dd->harga_barang->harga_beli }}">
                                            <div class="col-md-3">
                                                <div class="input-group ex-margin">
                                                    <input type="text" class="form-control nama" placeholder="Pilih Barang" readonly value="{{ $dd->harga_barang->barang->nm_barang }}">
                                                    <span class="input-group-btn">
                                                    <button class="btn btn-success pilih-barang" type="button" data-toggle="modal" data-target="#pilihBarang" data-id="list-harga-{{ $no }}" data-kode="kode-{{ $no }}"><i class="fa fa-plus"></i></button>
                                                    <input type="hidden" name="id_harga_barang[]" class="kode" value="{{ $dd->id_harga_barang }}">
                                                    </span>
                                                </div>
                                                
                                            </div>

                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    
                                                    <div class=" col-md-12">
                                                        <input type="number" step="0.01"  name="jumlah[]" class="form-control jumlah jumlahnya" min="0.1" value="{{ $dd->jumlah }}" onkeyup="get_total()" onchange="get_total()">
                                                        
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    
                                                    <div class=" col-md-12">
                                                        <input type="number" step="0.01"  name="diskon[]" class="form-control" required="" min="0" value="{{ $dd->diskon }}" >
                                                        
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    
                                                    <div class=" col-md-12">
                                                        <strong class="harga">Rp.{{ $dd->harga_barang->harga_beli }}</strong>
                                                        
                                                    </div>
                                                </div>
                                            </div>


                                            <div class="col-md-1">
                                                <div class="form-group">
                                                    
                                                    <div class=" col-md-12">
                                                        <button type="button" data-id="list-harga-{{ $no }}" class="delete_row">X</button>
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php $no++; ?>
                                    @endforeach

                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="col-md-3">
                                            <strong>Total</strong>
                                        </div>
                                        <div class="col-md-2" >
                                            <label id="total_jumlah">0</label>
                                        </div>

                                        <div class="col-md-2">
                                            
                                        </div>

                                        <div class="col-md-2" >
                                            <label id="total_harga">Rp.0</label>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                
                                <br>
                                <div class="row">
                                    
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            
                                            <div class="col-md-12">
                                                <div class="form-actions">
                                                    <button type="button" class="btn btn-danger" id="add_row">Add List</button>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div class="row">
                                    <div class="col-md-5">
                                        <div class="form-group ">
                                            <label class="col-md-4 control-label">Uang DP : </label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control " name="dp" id="dp" min="0" value="{{ $data->dp }}" >
                                                
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <br>
                                <div class="row">
                                    
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            
                                            <div class="col-md-12">
                                                <div class="form-actions">
                                                    <button type="submit" class="btn btn-primary">Edit</button>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    
                                    
                                </div>
                            </div>
                        </div>
                    </div>    
                </div>
                

            </div>
        </form>
        
    </div>
</div>

<div class="row " id="list-harga" style="display: none;" data-harga="0">
    <div class="col-md-3">
        <div class="input-group ex-margin">
            <input type="text" class="form-control nama" placeholder="Pilih Barang" readonly>
            <span class="input-group-btn">
            <button class="btn btn-success pilih-barang " type="button" data-toggle="modal" data-target="#pilihBarang" data-id="list-harga"><i class="fa fa-plus"></i></button>
            <input type="hidden" name="id_harga_barang[]" class="kode">
            </span>
        </div>
        
    </div>

    <div class="col-md-2">
        <div class="form-group">
            
            <div class=" col-md-12">
                <input type="number" step="0.01"  name="jumlah[]" class="form-control jumlah" required="" min="0.1" value="1" onkeyup="get_total()" onchange="get_total()">
                
            </div>
        </div>
    </div>

    <div class="col-md-2">
        <div class="form-group">
            
            <div class=" col-md-12">
                <input type="number" step="0.01"  name="diskon[]" class="form-control diskon" required="" min="0" value="0">
                
            </div>
        </div>
    </div>

    <div class="col-md-2">
        <div class="form-group">
            
            <div class=" col-md-12">
                <strong class="harga">Rp.0</strong>
                
            </div>
        </div>
    </div>



    <div class="col-md-1">
        <div class="form-group">
            
            <div class=" col-md-12">
                <button type="button" data-id="list-harga-1" class="delete_row" >X</button>
                
            </div>
        </div>
    </div>
</div>


<div id="pilihBarang" class="modal fade" role="dialog">
  <div class="modal-dialog modal-lg">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Barang</h4>
      </div>
      <div class="modal-body" >
        <div class="row">
            <div class="col-md-6">
            </div>
            <div class="col-md-6">
                <form class="form-horizontal">
                    <div class="form-group">
                        <label class="col-md-6 control-label">Search:</label>
                        <div class=" col-md-6">
                            <input class="form-control search" type="text" placeholder="Search" name="s" value="<?php echo (isset($_GET['s']))?$_GET['s']:''; ?>">
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="row" id="list-data">
            
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>

  </div>
</div>
<script src="{{ asset('js/app.js') }}"></script>
<script type="text/javascript">
    var cur_id ="list-harga-1";
    var total_jumlah = 0;
    var total_harga = 0;
    get_total();
    function get_total() {
        var j = $(".jumlahnya");
        var h = $(".list-harga");
        total_jumlah = 0;
        total_harga = 0;
        for (var i = 0; i < h.length; i++) {

            total_jumlah += parseFloat($(".jumlahnya").eq(i).val());
            total_harga += parseFloat($(".jumlahnya").eq(i).val()) * parseFloat(h.eq(i).data('harga'));
        }
        $("#total_jumlah").html(parseFloat(total_jumlah));

        $("#total_harga").html("Rp."+total_harga);

        // $("#uang_bayar").attr('min',total_harga);

    }
    jQuery(document).ready(function ($) {

        $(document).on('click','.pilih-barang',function (e) {
            cur_id = $(this).data('id');
           
        });

        $(document).on('click','#add_row',function (e) {
            
            get_total();
        });

        
        $(document).on('click','.delete_row',function (e) {
             $("#"+$(this).data('id')).remove();
            
            get_total();
        });
        $(document).on('click','.terpilih',function (e) {
            $("#"+cur_id+" .kode").val($(this).data('kode'));
            $("#"+cur_id+" .nama").val($(this).data('nama'));
            $("#"+cur_id+" .diskon").val($(this).data('diskon'));
            // $("#"+cur_id+" .jumlah").attr('min',$(this).data('stok'));
            $("#"+cur_id+" .harga").html("Rp."+$(this).data('hargabeli'));
            $("#"+cur_id+" .delete_row").data("jumlah",$(this).data('stok'));
            $("#"+cur_id).data("harga",$(this).data('hargabeli'));
            
            
            get_total();
        });


        
        


        var ss = "";
        $(document).on('click', '.pagination a',function(event)
        {
            event.preventDefault();
  
            $('li').removeClass('active');
            $(this).parent('li').addClass('active');
  
            var myurl = $(this).attr('href');
            var page=$(this).attr('href').split('page=')[1];
            
            get_data_barang(ss,page);
            
        });

        $(document).on('keyup', '.search',function(event)
        {
            
            get_data_barang($(this).val(),1);
            
        });

        $(document).on('click','.pilih-barang',function (e) {
            get_data_barang(ss,1);
        });

        function get_data_barang(s,p) {
            ss = s;
            $.ajax({
                url: '{{ url("api/barang") }}?page='+p+'&s='+s,
                type: 'GET',
                
                success: function (data) {
                    $("#list-data").html(data);
                    // $(".search")[0].focus();
                }
            });
        }
    });
    
</script>
@endsection
