@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li  ><a href="{{ url($url) }}">{{ $title }}</a></li>
                                <li class="active-page" ><a href="{{ url($url) }}">Detail Data {{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <form class="form-horizontal" method="post" action="{{ url($url.'/'.$data->no_pembelian) }}">

            <div class="row">
                <div class="col-md-12">
                    <div class="box-widget widget-module">
                        <div class="widget-head clearfix">
                            <span class="h-icon"><i class="fa fa-table"></i></span>
                            <h4>Detail {{ $title }}</h4>
                            
                            <div class="pull-right" style="padding: 10px;">
                             
                                <a href="{{ url($url.'/'.$data->no_pembelian.'/cetak') }}" class="btn btn-primary btn-sm" target="_blank" style="cursor:pointer;">Cetak</a>
                            </div>
                        </div>
                        <div class="widget-container">
                            <div class="widget-block">
                                <div id="list-contain">
                                    
                                    
                                    


                                    <table class="table table-striped table-responsive"  style="margin-top: -10px;" width="800" border="0" cellspacing="1" cellpadding="2">
                                        <tr >
                                          <td width="29" ><strong>No</strong></td>
                                          <td width="85" ><strong>Kode</strong></td>
                                          <td width="432"><strong>Nama Barang </strong></td>
                                          <td width="85" align="right"><strong>Harga (Rp) </strong></td>
                                          <td width="60" align="right"><strong>Diskon (%)</strong></td>
                                          <td width="48" align="right"><strong>Jumlah</strong></td>
                                          <td width="100" align="right"><strong>Sub Total(Rp) </strong></td>
                                          <td width="22" align="center">&nbsp;</td>
                                        </tr>
                                    <?php $no = 1; 
                                    $hargaDiskon= 0; 
                                    $totalBayar = 0; 
                                    $jumlahbarang   = 0;
                                    ?>
                                    @foreach($data->detail as $dd)
                                    <?php
                                        
                                        $hargaDiskon= $dd->harga_barang->harga_beli - ( $dd->harga_barang->harga_beli * $dd->diskon/100);
                                        $subSotal   = $dd->jumlah * $hargaDiskon ;
                                        $totalBayar = $totalBayar + $subSotal;
                                        $jumlahbarang   = $jumlahbarang + $dd->jumlah;
                                    ?>
                                        <tr>
                                          <td><?php echo $no; ?></td>
                                          <td><?php echo $dd->harga_barang->barang->kd_barang; ?></b></td>
                                          <td><?php echo $dd->harga_barang->barang->nm_barang; ?></td>
                                          <td align="right"><?php echo number_format($dd->harga_barang->harga_beli); ?></td>
                                          <td align="right"><?php echo $dd->diskon; ?></td>
                                          <td align="right"><?php echo $dd->jumlah; ?></td>
                                          <td align="right"><?php echo number_format($subSotal); ?></td>
                                          <td></td>
                                        </tr>
                                        
                                        <?php $no++; ?>
                                    @endforeach
                                        <tr>
                                          <td colspan="5" align="right" ><strong>TOTAL BELANJA  (Rp.) : </strong></td>
                                          <td align="right" ><b><?php echo $jumlahbarang; ?></b></td>
                                          <td align="right" ><b><?php echo number_format($totalBayar); ?></b></td>
                                          <td >&nbsp;</td>
                                        </tr>
                                        
                                        <?php 
                                            $ppn = 0;
                                            if($data->ppn == 1){
                                              $ppn = $totalBayar * 10/100;
                                            }
                                            
                                            $grandTotal = $totalBayar + $ppn;
                                         ?>
                                        <tr>
                                          <td colspan="5" align="right" ><strong>PPN (10%) : </strong></td>
                                          <td align="right" ><b>&nbsp;</b></td>
                                          <td align="right" ><b>{{ number_format($ppn) }}</b></td>
                                          <td >&nbsp;</td>
                                        </tr>
                                        <tr>
                                          <td colspan="5" align="right" ><strong>Total (Rp.) : </strong></td>
                                          <td align="right" ><b>&nbsp;</b></td>
                                          <td align="right" ><b>{{ number_format($grandTotal) }}</b></td>
                                          <td >&nbsp;</td>
                                        </tr>

                                        <tr>
                                          <td colspan="5" align="right" ><strong>DP (Rp.) : </strong></td>
                                          <td align="right" ><b>&nbsp;</b></td>
                                          <td align="right" ><b>{{ number_format($data->dp) }}</b></td>
                                          <td >&nbsp;</td>
                                        </tr>
                                      </table>
                                </div>
                                
                            
                            </div>
                        </div>
                    </div>    
                </div>
                
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="box-widget widget-module">
                        <div class="widget-head clearfix">
                            <span class="h-icon"><i class="fa fa-table"></i></span>
                            <h4>Data {{ $title }}</h4>
                            <div class="pull-right" style="padding: 10px;">
                             
                                <a href="{{ url($url) }}" class="btn  btn-warning ">Kembali</a>
                            </div>
                            
                        </div>
                        <div class="widget-container">
                            <div class="widget-block">
                                <div class="row">
                                    
                                    <div class="col-md-6">
                                     
                                        
                                        @csrf
                                        <input type="hidden" name="_method" value="PUT">
                                        

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">No Pembelian</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control" name="no_pembelian" placeholder="No Pembelian" readonly="" value="{{ $data->no_pembelian }}" disabled="" readonly="">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Tanggal Pembelian</label>
                                            <div class=" col-md-8">
                                                <input type="date" class="form-control" name="tgl_pembelian" value="{{ $data->tgl_pembelian}}" disabled="" readonly="">
                                                
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Pilih Supplier</label>
                                            <div class=" col-md-8">
                                                <select class="form-control" required="" name="kd_supplier" disabled="" readonly="">
                                                    <option>Pilih Supplier</option>
                                                    @foreach($suppliers as $supplier)
                                                    <option value="{{ $supplier->kd_supplier }}" @if($supplier->kd_supplier == $data->kd_supplier) selected @endif>{{ $supplier->nm_supplier }}</option>
                                                    @endforeach
                                                </select>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Keterangan</label>
                                            <div class=" col-md-8">
                                              {{$data->keterangan}}
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">PPN 10%</label>
                                            <div class=" col-md-8">
                                                <input type="checkbox" @if($data->ppn == 1) checked="checked" @endif name="ppn" readonly="" disabled="">
                                                
                                            </div>
                                        </div>

                                        
                                        
                                    </div>

                                  
                                    
                                </div>
                            </div>
                        </div>
                    </div>    
                </div>
            
            </div>
        </form>
        
    </div>
</div>


@endsection
