@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li  ><a href="{{ url($url) }}">{{ $title }}</a></li>
                                <li class="active-page" ><a href="{{ url($url) }}">Tambah Data {{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <form class="form-horizontal" method="post" action="{{ url($url) }}" id="myForm">
            <div class="row">
                <div class="col-md-12">
                    <div class="box-widget widget-module">
                        <div class="widget-head clearfix">
                            <span class="h-icon"><i class="fa fa-table"></i></span>
                            <h4>Data {{ $title }}</h4>
                            <div class="pull-right" style="padding: 10px;">

                                <a href="{{ url($url) }}" class="btn  btn-warning ">Kembali</a>
                            </div>
                            
                        </div>
                        <div class="widget-container">
                            <div class="widget-block">
                                <div class="row">

                                    <div class="col-md-6">


                                        @csrf

                                        

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">No Pembelian</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control input-sm" name="no_pembelian" placeholder="No Pembelian" readonly="" value="{{ ++$kd }}">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Tanggal Pembelian</label>
                                            <div class=" col-md-8">
                                                <input type="date" class="form-control input-sm" name="tgl_pembelian" value="{{ date('Y-m-d') }}">
                                                
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Pilih Supplier</label>
                                            <div class=" col-md-8">
                                                <select class="form-control input-sm select2" required="" name="kd_supplier">

                                                    @foreach($suppliers as $supplier)
                                                    <option value="{{ $supplier->kd_supplier }}">{{ $supplier->nm_supplier }}</option>
                                                    @endforeach
                                                </select>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Keterangan</label>
                                            <div class=" col-md-8">
                                                <select class="form-control input-sm" required="" name="keterangan" id="keterangan">

                                                    <option value="Cash">Cash</option>
                                                    @foreach($metode as $metodes)
                                                    <option value="{{ $metodes->metode }}">{{ $metodes->metode }} - {{$metodes->keterangan}}</option>
                                                    @endforeach
                                                </select>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">PPN 10%</label>
                                            <div class=" col-md-8">
                                                <input type="checkbox" name="ppn" id="ppn_check">
                                                
                                            </div>
                                        </div>
                                        
                                        
                                    </div>


                                    
                                </div>
                            </div>
                        </div>
                    </div>    
                </div>
                

            </div>
            <style type="text/css">
            .list-harga input,.list-harga select {
                font-size: 10px;
            }
        </style>
        <div class="row">
            <div class="col-md-12">
                <div class="box-widget widget-module ">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-bars"></i></span>
                        <h4 class="widget-collapse waves-effect w-collapse">Petunjuk (klik Untuk Membuka Petunjuk Pengisian Detail Pembelian)</h4>
                        <ul class="widget-action-bar pull-right">
                            <li><span class="widget-collapse waves-effect w-collapse"><i class="fa fa-angle-down"></i></span>
                            </li>
                            
                        </ul>
                    </div>
                    <div class="widget-container bg-danger" style="display: none;">
                        <div class="widget-block">
                            <p><strong>Barang</strong> = Memilih barang & harga barang yang akan di pilih</p>
                            <p><strong>Jumlah</strong> = Jumlah barang yang akan dibeli (berdasarkan satuan beli barang)</p>
                            <p><strong>Diskon</strong> = diskon harga jual dalam persen</p>
                            <p><strong>Harga Baru</strong> = bila harga barang yang di beli ke supplier berbeda dengan harga di data barang maka bisa mengisi harga baru di sini</p>
                            <p><strong>Aksi</strong> = memilih aksi untuk harga baru apakah harga baru yang di input akan di tambahkan ke data baru atau mengupdate harga baru ke harga lama yang dipilih</p>
                            <p><strong>Harga Beli</strong> = harga beli dari data barang yang dipilih</p>
                            <p><strong>Harga Jual</strong> = harga jual dari data barang yang dipilih (bisa di ubah dan di simpan)</p>
                        </div>
                    </div>
                </div>

                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Detail {{ $title }}</h4>

                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            <div id="list-contain">
                                <div class="row" style="font-size: 10px;">
                                    <div class="col-md-2">
                                        <label>Barang</label>
                                    </div>
                                    <div class="col-md-1">
                                        <label>Jumlah </label>
                                    </div>

                                    <div class="col-md-1">
                                        <label>Diskon</label>
                                    </div>

                                    <div class="col-md-2">
                                        <label>Harga Baru</label>
                                    </div>

                                    <div class="col-md-1">
                                        <label>Aksi</label>
                                    </div>

                                    <div class="col-md-2">
                                        <label>Harga Beli</label>
                                    </div>

                                    <div class="col-md-2">
                                        <label>Harga Jual</label>
                                    </div>



                                </div>


                                <div class="row list-harga" id="list-harga-0" data-harga="0" data-diskon="0">
                                    <div class="col-md-2">
                                        <div class="input-group ex-margin">
                                            <input type="text" class="form-control input-sm nama" placeholder="Pilih Barang"  required="">
                                            <span class="input-group-btn ">
                                                <a href="#" data-bb="html_forms" class="btn btn-sm btn-success pilih-barang" type="button"  data-id="list-harga-0" data-kode="kode-0"><i class="fa fa-plus"></i></a>
                                                <input type="hidden" name="id_harga_barang[]" class="kode" required="">
                                            </span>
                                        </div>

                                    </div>

                                    <div class="col-md-1">


                                        <div class="input-group ex-margin">
                                            <input style="padding: 0;" type="number" step="0.01"  name="jumlah[]" class="form-control input-sm jumlah jumlahnya" min="0.1" value="1" onkeyup="get_total()" onchange="get_total()" required="">

                                        </div>
                                    </div>

                                    <div class="col-md-1">
                                        <div class="form-group">

                                            <div class=" col-md-12">
                                                <input style="padding: 0;" type="number" step="0.01"  name="diskon[]" class="form-control input-sm diskon" onkeyup="get_total()" onchange="get_total()" required="" min="0" value="0" required="" >

                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-2">
                                        <div class="form-group">

                                            <div class=" col-md-12">
                                                <input type="number" step="0.01"  name="harga_baru[]" data-id="list-harga-0" onchange="harga_baru(this)" class="harga_baru form-control input-sm" min="0" value="0" required="" >

                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-1">
                                        <div class="form-group">

                                            <select class="col-md-12" style="padding: 0;margin: auto;" name="jenis_harga[]" required="">
                                                <option value="tidak">......</option>
                                                <option value="add">Tambah Harga Baru</option>
                                                <option value="update">Update Harga</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-2">
                                        <div class="form-group">

                                            <div class=" col-md-12">
                                                <strong class="harga"></strong>
                                                <div class="input-group ex-margin">
                                                    <input type="text" disabled readonly="" class="form-control input-sm harga" value="Rp.0">

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-2">
                                        <div class="form-group">

                                            <div class=" col-md-12">
                                                <strong class="harga"></strong>
                                                <div class="input-group ex-margin">
                                                    <input type="number" step="0.01"  name="harga_jual[]" data-id="list-harga-0"  class="harga_jual form-control input-sm" min="0" value="0" required="" >

                                                </div>
                                            </div>

                                            <div class=" col-md-12">


                                            </div>
                                        </div>
                                    </div>



                                    <div class="col-md-1">
                                        <div class="form-group">

                                            <div class=" col-md-12">
                                                <!-- <button type="button" data-id="list-harga-1" class="delete_row">X</button> -->

                                            </div>
                                        </div>
                                    </div>
                                </div>




                            </div>
                            <br>
                            <br>
                            <div class="row">
                                <div class="col-md-12">
                                    <table>
                                        <tr>
                                          <td colspan="5" align="right" ><strong >Total Barang : </strong></td>
                                          <td align="right" ><b>&nbsp;</b></td>
                                          <td align="right" ><b id="total_jumlah">0</b></td>
                                          <td >&nbsp;</td>
                                      </tr>

                                      <tr>
                                          <td colspan="5" align="right" ><strong >PPN (10%) : </strong></td>
                                          <td align="right" ><b>&nbsp;</b></td>
                                          <td align="right" ><b id="ppn">Rp.0</b></td>
                                          <td >&nbsp;</td>
                                      </tr>

                                      <tr>
                                          <td colspan="5" align="right" ><strong>Total : </strong></td>
                                          <td align="right" ><b>&nbsp;</b></td>
                                          <td align="right" ><b id="total_harga">Rp.0</b></td>
                                          <td >&nbsp;</td>
                                      </tr>
                                      <tr>
                                        <td colspan="6">&nbsp;</td>
                                        <td >

                                        </td>
                                        <td>&nbsp;</td>

                                    </tr>
                                </table>

                            </div>
                        </div>
                        <br>

                        <br>
                        <div class="row">

                            <div class="col-md-2">
                                <div class="form-group">

                                    <div class="col-md-12">
                                        <div class="form-actions">
                                            <button type="button" class="btn btn-danger" id="add_row">Add List</button>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-5">
                                <div class="form-group ">
                                    <label class="col-md-4 control-label">Uang DP : </label>
                                    <div class=" col-md-8">
                                        <input type="text" class="form-control input-sm " name="dp" id="dp" min="0" value="0" >

                                    </div>
                                </div>
                            </div>

                        </div>
                        <br>
                        <div class="row">

                            <div class="col-md-2">
                                <div class="form-group">

                                    <div class="col-md-12">
                                        <div class="form-actions">
                                            <button type="submit" class="btn btn-primary">Tambah</button>

                                        </div>
                                    </div>
                                </div>
                            </div>



                        </div>
                    </div>
                </div>
            </div>    
        </div>


    </div>
</form>

</div>
</div>

<div class="row " id="list-harga" style="display: none;" data-harga="0">
    <div class="col-md-2">
        <div class="input-group ex-margin">
            <input type="text" class="form-control input-sm nama" placeholder="Pilih Barang"  required="">
            <span class="input-group-btn ">
                <a href="#" data-bb="html_forms" class="btn btn-sm btn-success pilih-barang" type="button"  data-id="list-harga-0" data-kode="kode-0"><i class="fa fa-plus"></i></a>
                <input type="hidden" name="id_harga_barang[]" class="kode" required="">
            </span>
        </div>

    </div>

    <div class="col-md-1">


        <div class="input-group ex-margin">
            <input style="padding: 0;" type="number" step="0.01"  name="jumlah[]" class="form-control input-sm jumlah jumlahnya" min="0.1" value="1" onkeyup="get_total()" onchange="get_total()" required="">

        </div>
    </div>

    <div class="col-md-1">
        <div class="form-group">

            <div class=" col-md-12">
                <input style="padding: 0;" type="number" step="0.01"  name="diskon[]" class="form-control input-sm diskon" onkeyup="get_total()" onchange="get_total()" required="" min="0" value="0" required="" >

            </div>
        </div>
    </div>

    <div class="col-md-2">
        <div class="form-group">

            <div class=" col-md-12">
                <input type="number" step="0.01"  name="harga_baru[]" data-id="list-harga-0" onchange="harga_baru(this)" class="harga_baru form-control input-sm" min="0" value="0" required="" >

            </div>
        </div>
    </div>

    <div class="col-md-1">
        <div class="form-group">

            <select class="col-md-12" style="padding: 0;margin: auto;" name="jenis_harga[]" required="">
                <option value="tidak">......</option>
                <option value="add">Tambah Harga Baru</option>
                <option value="update">Update Harga</option>
            </select>
        </div>
    </div>

    <div class="col-md-2">
        <div class="form-group">

            <div class=" col-md-12">
                <strong class="harga"></strong>
                <div class="input-group ex-margin">
                    <input type="text" disabled readonly="" class="form-control input-sm harga" value="Rp.0">

                </div>
            </div>
        </div>
    </div>

    <div class="col-md-2">
        <div class="form-group">

            <div class=" col-md-12">
                <strong class="harga"></strong>
                <div class="input-group ex-margin">
                    <input type="number" step="0.01"  name="harga_jual[]" data-id="list-harga-0"  class="harga_jual form-control input-sm" min="0" value="0" required="" >

                </div>
            </div>

            <div class=" col-md-12">


            </div>
        </div>
    </div>



    <div class="col-md-1">
        <div class="form-group">

            <div class=" col-md-12">
                <button type="button" data-id="list-harga-1" class="delete_row">X</button>

            </div>
        </div>
    </div>
</div>


<script src="{{ asset('js/app.js') }}"></script>
<script src="{{ asset('js/numeral-js/numeral.js') }}"></script>
<script type="text/javascript">
    var cur_id ="list-harga-1";
    var total_jumlah = 0;
    var total_harga = 0;

    $('#ppn_check').on('click', function(e) {
        get_total();
    });

        

    function get_total() {
        var j = $(".jumlahnya");
        var h = $(".list-harga");
        total_jumlah = 0;
        total_harga = 0;
        var ppn = 0;
        var diskon = 0;

        for (var i = 0; i < h.length; i++) {

            total_jumlah += parseFloat($(".jumlahnya").eq(i).val());
            diskon = h.eq(i).data('harga') * h.eq(i).find('.diskon').val()/100;

            total_harga += parseFloat($(".jumlahnya").eq(i).val()) * ( h.eq(i).data('harga') - diskon);
        }
        $("#total_jumlah").html(parseFloat(total_jumlah));

        if($('#ppn_check').is(':checked',true))  
        {
            ppn = (total_harga * 10/100);
            
        }  
        $("#total_harga").html("Rp."+numeral((total_harga+ppn)).format('0,0'));
        $("#ppn").html("Rp."+ppn);

        // $("#uang_bayar").attr('min',total_harga);

    }

    function harga_baru(e){
        $("#"+$(e).data('id')).data("harga",e.value);
        $("#"+$(e).data('id')+" .harga").html("Rp."+numeral(e.value).format('0,0'));
        get_total();
    }



    jQuery(document).ready(function ($) {

        $(document).on('submit','#myForm',function (e) {
            // e.preventDefault();
            // alert(total_harga);
            if(($("#keterangan").val() == "Cash" || $("#keterangan").val() == "Transfer Cash") && total_harga > $("#dp").val()){
                e.preventDefault();
                alert('Uang Pembayaran TIdak Cukup');
            } 

        });

        $(document).on('click','.pilih-barang',function (e) {
            cur_id = $(this).data('id');

        });

        $(document).on('click','#add_row',function (e) {

            get_total();
        });

        
        $(document).on('click','.delete_row',function (e) {
           $("#"+$(this).data('id')).remove();

           get_total();
       });
        $(document).on('click','.terpilih',function (e) {
            $("#"+cur_id+" .kode").val($(this).data('kode'));
            $("#"+cur_id+" .nama").val($(this).data('nama'));
            $("#"+cur_id+" .diskon").val($(this).data('diskon'));
            // $("#"+cur_id+" .jumlah").attr('min',$(this).data('stok'));
            $("#"+cur_id+" .harga").val("Rp."+numeral($(this).data('hargabeli')).format('0,0'));
            $("#"+cur_id+" .harga_jual").val($(this).data('hargajual'));
            $("#"+cur_id+" .delete_row").data("jumlah",$(this).data('stok'));
            $("#"+cur_id).data("diskon",$(this).data('diskon'));
            $("#"+cur_id).data("harga",$(this).data('hargabeli'));

            $("#"+cur_id+" .stn1").html($(this).data('satuan-beli'));
            $("#"+cur_id+" .stn3").html($(this).data('satuan-beli'));
            $("#"+cur_id+" .stn2").html($(this).data('satuan-jual'));
            get_total();
        });


        
        


        var ss = "";
        $(document).on('click', '.pagination a',function(event)
        {
            event.preventDefault();

            $('li').removeClass('active');
            $(this).parent('li').addClass('active');

            var myurl = $(this).attr('href');
            var page=$(this).attr('href').split('page=')[1];
            
            get_data_barang(ss,page);
            
        });

        $(document).on('keyup', '.search',function(event)
        {

            get_data_barang($(this).val(),1);
            
        });

        $(document).on('click','.pilih-barang',function (e) {
            get_data_barang(ss,1);
        });

        $(document).on('change','#select-jenis',function (e) {

            get_data_barang(ss,1);
        });

        $(document).on('change','#select-merek',function (e) {

            get_data_barang(ss,1);
        });




        $(document).on('keyup','.jumlah',function (e) {
            get_total();
        });

        $(document).on('change','.jumlah',function (e) {
            get_total();
        });

        $(document).on('change','#select-urutkan',function (e) {

            get_data_barang(ss,1);
        });
        
        function get_data_barang(s,p) {
            ss = s;
            var j = '';
            var m = '';
            var u = '';
            if($("#select-jenis").val() != undefined){
                j = $("#select-jenis").val();
            }
            if($("#select-merek").val() != undefined){
                m = $("#select-merek").val();
            }

            if($("#select-urutkan").val() != undefined){
                u = $("#select-urutkan").val();
            }
            $.ajax({
                url: '{{ url("api/barang") }}?page='+p+'&s='+s+'&kd_jenis='+j+'&kd_merek='+m+'&urutkan='+u,
                type: 'GET',
                
                success: function (data) {
                    $("#list-data").html(data);
                    // $(".search")[0].focus();
                }
            });
        }
    });
    
</script>
@endsection
