@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li class="active-page"><a href="{{ url($url) }}">{{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <!-- <div class="section-header">
                    <h2>Table with simple header <code>.matmix-dt</code></h2>
                    <p>
                        This table is well styled and included edit delete options. You can use it in any table and this table support all bootstrap table classes like<code>.table, .table-striped, .table-hover, .table-bordered</code>
                    </p>
                </div> -->
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data {{ $title }}</h4>
                        <div class="pull-right" style="padding: 10px;">
                            <a href="{{ url($url.'/export') }}" class="btn  btn-warning "><i class="fa fa-file-excel-o"></i> Export Excel</a>
                            <a href="{{ url($url.'/import') }}" class="btn  btn-success "><i class="fa fa-file-excel-o"></i> Import Excel</a>
                            <a href="{{ url($url.'/create') }}" class="btn  btn-info ">Tambah Data</a>
                        </div>
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            @include('layouts.includes.search')
                            <div class="table-responsive">
                                <button style="margin-bottom: 10px" class="btn btn-danger delete_all" data-url="{{ url($url.'/deleteAll') }}">Delete All Selected</button>
                                <table class="table table-striped table-hover table-bordered matmix-dt">
                                    <thead>
                                        <tr>
                                            <th class="tc-center">
                                                <input type="checkbox"  id="master">
                                            </th>
                                            <th>
                                                No
                                            </th>
                                            <th>
                                                Nama Pelanggan
                                            </th>
                                            
                                            <th>
                                                Alamat
                                            </th>

                                            <th>
                                                Telp / WA
                                            </th>
                                            <th>
                                                Status
                                            </th>
                                            <th>
                                                Point
                                            </th>
                                            <th class="tc-center">
                                                Aksi
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                            $page = 0;
                                            if(isset($_GET['page']) && $_GET['page'] > 1){
                                                $page = $_GET['page']*10-10;
                                            }
                                            $no = 1*$page+1; 
                                         ?>
                                        @foreach($datas as $data)
                                            <tr>
                                                <td class="tc-center">
                                                    <input type="checkbox" class=" sub_chk" data-id="{{$data->kd_pelanggan}}">
                                                </td>
                                                <td>
                                                    {{ $no++ }}
                                                </td>
                                                <td>
                                                    {{ $data->nm_pelanggan }}
                                                </td>
                                              
                                                <td>
                                                    {{ $data->alamat }}
                                                </td>
                                                <td>
                                                    {{ $data->no_telepon }} / {{ $data->no_wa }}
                                                </td>
                                                <td>
                                                    @if($data->status == 0)
                                                        Pelanggan
                                                    @else
                                                        Reseller
                                                    @endif
                                                </td>
                                                <td align="center">
                                                    @if($data->status == 1 )
                                                    {{ $data->point }}
                                                    <a href="{{ url('poin/'.$data->kd_pelanggan) }}" class="btn btn-warning btn-sm "> Gunakan Poin </a>
                                                    @endif
                                                </td>
                                                <td class="tc-center">
                                                    @include('layouts.includes.aksi',['id'=>$data->kd_pelanggan])
                                                </td>
                                            </tr>
                                        @endforeach
                                        
                                    </tbody>
                                </table>
                            </div>
                            <div class="dt-pagination">
                                <nav>
                                    {!! $datas->links() !!}
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        
    </div>
</div>

@endsection
