@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li  ><a href="{{ url($url) }}">{{ $title }}</a></li>
                                <li class="active-page" ><a href="{{ url($url) }}">Tambah Data {{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data {{ $title }}</h4>
                        <div class="pull-right" style="padding: 10px;">
                           
                            <a href="{{ url($url) }}" class="btn  btn-warning ">Kembali</a>
                        </div>
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            <div class="row">
                                <div class="col-md-6">

                                    <form class="form-horizontal" method="post" action="{{ url($url) }}">
                                        @csrf

                                        

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Nama Pelanggan</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control" name="nm_pelanggan" placeholder="Nama Pelanggan" required>
                                                
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Alamat</label>
                                            <div class=" col-md-8">
                                                <textarea class="form-control" name="alamat" placeholder="Alamat" required></textarea>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Kota</label>
                                            <div class=" col-md-8">
                                                <select class="form-control select2" name="kota" required>
                                                    @foreach($data as $datas)
                                                    <option value="{{$datas->city_id}}">{{$datas->title}}</option>
                                                    @endforeach
                                                </select>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Telepon</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control phone-mask" name="no_telepon" required>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">No Wa</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control phone-mask" name="no_wa" required>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Status</label>
                                            <div class=" col-md-8">
                                                <select class="form-control select2" name="status" required>
                                                    <option value="0" selected="">Pelanggan</option>
                                                    <option value='1'>Reseller</option>
                                                </select>
                                                
                                            </div>
                                        </div>



                                        <div class="form-group">
                                            <label class="col-md-4 control-label">&nbsp;</label>
                                            <div class="col-md-8">
                                                <div class="form-actions">
                                                    <button type="submit" class="btn btn-primary">Tambah</button>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                        
                                    </form>
                                </div>
                               
                            </div>
                        </div>
                    </div>
                </div>    
            </div>
                

        </div>
        
    </div>
</div>

@endsection
