@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li  ><a href="{{ url($url) }}">{{ $title }}</a></li>
                                <li class="active-page" ><a href="{{ url($url) }}">Tambah Data {{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data {{ $title }}</h4>
                        <div class="pull-right" style="padding: 10px;">
                           
                            <a href="{{ url($url) }}" class="btn  btn-warning ">Kembali</a>
                        </div>
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            <div class="row">
                                <div class="col-md-6">
                                   
                                    <form action="{{ url($url.'/'.$data->id) }}" method="POST">
                                        @csrf

                                        <input type="hidden" name="_method" value="PUT">
                                        <div class="form-group col-md-6">
                                            <label for="nm_level" class="form-label">Nama Level</label>
                                            <input required type="text" class="form-control" id="nm_level" name="nm_level" value="<?php echo $data['nm_level'] ?>">
                                        </div>
                                        <br>
                                        <br>
                                        <div class="form-group col-md-12">
                                            <h4>Pilih Hak Akses Menu</h4>
                                            <input id="all" type="checkbox" class="master_check" target-class="all">
                                            <label for="all">Pilih Semua</label>
                                        </div>

                                        <?php $nm_menu = ""; ?>
                                            @foreach($menus as $menu)
                                                @if($nm_menu != $menu->nm_menu)
                                                <?php $nm_menu = $menu->nm_menu ?>

                                                <br>
                                                <br>
                                                    <div class="col-md-12" >
                                                        <label  class="label label-info" >{{ $menu->nm_menu }}</label> 
                                                        <input type="checkbox" class="master_check all" target-class="check-{{ str_replace(' ','',$nm_menu) }}">
                                                    </div>
                                                    <div class="col-md-3" style="float: left;">
                                                        <label   >{{ $menu->aksi_menu }}</label> 
                                                        <input type="checkbox" class="all check-{{ str_replace(' ','',$nm_menu) }}" value="{{ $menu->id }}" name="id_menu[]" @if($data->check_detail($menu->id)) checked="" @endif>
                                                    </div>
                                                                                    @else 
                                                    <div class="col-md-3" style="float: left;">
                                                        <label   >{{ $menu->aksi_menu }}</label> 
                                                        <input type="checkbox" class="all check-{{ str_replace(' ','',$nm_menu) }}" value="{{ $menu->id }}" name="id_menu[]" @if($data->check_detail($menu->id)) checked="" @endif>
                                                    </div>
                                                @endif
                                            @endforeach
                                            <div style="clear: both;margin-top: 100px;"></div>
                                        <button type="submit" class="btn btn-success">Edit</button>
                                    </form>
                                </div>
                               
                            </div>
                        </div>
                    </div>
                </div>    
            </div>
                

        </div>
        
    </div>
</div>

@endsection
