@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li class="active-page"><a href="{{ url($url) }}">{{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <!-- <div class="section-header">
                    <h2>Table with simple header <code>.matmix-dt</code></h2>
                    <p>
                        This table is well styled and included edit delete options. You can use it in any table and this table support all bootstrap table classes like<code>.table, .table-striped, .table-hover, .table-bordered</code>
                    </p>
                </div> -->
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data {{ $title }}</h4>
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            <div class="row">
                                <div class="col-md-4">
                                    <?php 
                                        $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                                        $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                                        $user_id = (isset($_GET['user_id']))?$_GET['user_id']:'';
                                        
                                     ?>
                                    <a href="{{ url($url.'/cetak?type=html&menu='.$_GET['menu'].'&from='.$from.'&to='.$to) }}" target="_blank"><img src="{{ asset('images/btn_print2.png') }}" height="18" border="0" title="Cetak ke Format HTML"/></a>
                                    |<a class="btn btn-default" href="{{ url($url.'/cetak?type=excel&menu='.$_GET['menu'].'&from='.$from.'&to='.$to.'&user_id='.$user_id) }}" target="_blank">Export ke Excel</a>  | <a href="{{ url($url) }}" class="btn btn-sm btn-warning">Kembali</a>
                                </div>
                                <div class="col-md-8">
                                    <form class="form-horizontal">
                                        <input type="hidden"  value="<?php echo (isset($_GET['s']))?$_GET['s']:''; ?>">
                                        <input type="hidden" name="menu" value="{{ $_GET['menu'] }}">
                                        <div class="form-group">
                                            
                                            <div class=" col-md-3">
                                                <input type="date" name="from" class="form-control" placeholder="Dari Tanggal" value="{{ $from }}" required>
                                            </div>
                                            <div class=" col-md-3">
                                                <input type="date" name="to" class="form-control" placeholder="Sampai Tanggal" value="{{ $to }}" required>
                                            </div>

                                            <!-- user -->
                                            <div class="col-md-3">
                                                <select name="user_id" class="form-control">
                                                    <option value="">All</option>
                                                    @foreach ($datas as $data)
                                                        <option value="{{$data->id}}" 
                                                                @if (isset($_GET['user_id']) && $_GET['user_id'] == $data->id)
                                                                    selected
                                                                @endif
                                                            >{{$data->name}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            
                                            <div class="col-md-3">
                                                <button class="btn btn-info">Tampil</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <!-- table -->
                            @if (isset($_GET['user_id']) && $_GET['user_id'] !== '')
                            <div class="table-responsive">
                                <div>
                                    <h4>Nama Karyawan : {{$user->name}}</h4>
                                </div>
                                <table class="table table-striped table-hover table-bordered matmix-dt">
                                    <thead>
                                        <tr>
                                            <th style="text-align:center;">No</th>
                                            <th>Penjualan</th>
                                            <th>Barang</th>
                                            <th>Keterangan</th>
                                            <th>Tanggal penjualan</th>
                                            <th>Harga Seluruh Barang</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $ttl = 0; $laba = 0;
                                        @endphp
                                       @foreach ($user->penjualan->whereBetween('tgl_penjualan', [$_GET['from'], $_GET['to']]) as $p)
                                           <tr>
                                               <td align="center" width="5%">{{ $loop->iteration }}</td>
                                               <td>{{$p->no_penjualan}}</td>
                                                <td >
                                                    @foreach ($p->detail as $dd)
                                                        @php
                                                            $hargaDiskon = $dd->harga_barang->harga_jual - $dd->diskon; 
                                                            $ttl += $dd->jumlah * $dd->harga_barang->harga_jual;
                                                            $laba += $ttl-($dd->harga_barang->harga_beli * $dd->jumlah);
                                                        @endphp
                                                       {{$dd->hasHargaBarang->barang->nm_barang}} {{ count($p->detail) == $loop->iteration ? '' : ',' }}
                                                    @endforeach
                                                </td>
                                               <td>{{$p->keterangan}}</td>
                                               <td>{{$p->tgl_penjualan}}</td>
                                               <td>
                                                   @php
                                                       $total_seluruh = 0;
                                                   @endphp
                                                   @foreach ($p->detail as $dd)
                                                       @php
                                                           $disc = $dd->harga_barang->harga_jual - $dd->diskon;
                                                           $total_seluruh += $dd->jumlah * $dd->harga_barang->harga_jual;
                                                           
                                                       @endphp
                                                   @endforeach
                                                   {{ 'Rp. ' . number_format($total_seluruh)}}
                                               </td>
                                               
                                           </tr>
                                       @endforeach
                                       <tr>
                                            <td colspan="5" align="center">Total Harga + Diskon </td>
                                            <td> {{ 'Rp ' . number_format($ttl) }} </td>
                                       </tr>
                                    </tbody>
                                </table>
                            </div>
                            @else
                            <div class="table-responsive">
                                
                                <table class="table table-striped table-hover table-bordered matmix-dt">
                                    <thead>
                                        <tr>
                                       
                                            <th>
                                                No
                                            </th>
                                           
                                            <th>
                                                Nama
                                            </th>
                                          
                                           <th>
                                               Waktu Dibuat
                                           </th>
                                           <th>
                                               Pendapatan
                                           </th>
                                         
                                         
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $no = 1; ?>
                                        @foreach($datas as $data)
                                            <tr>
                                                
                                                <td>
                                                    {{ $no++ }}
                                                </td>
                                                
                                                <td>
                                                    {{ $data->name }}
                                                </td>

                                                <td>
                                                    {{ date('Y-m-d',strtotime($data->created_at)) }}
                                                </td>
                                                <?php $ttl = 0;$laba = 0; ?>
                                                @foreach($data->penjualan as $p)
                                                    @foreach($p->detail as $dd)
                                                        <?php 
                                         
                                                        $hargaDiskon = $dd->harga_barang->harga_jual - $dd->diskon; 
                                                    
                                                        $ttl += $dd->jumlah * $dd->harga_barang->harga_jual;
                                                        $laba += $ttl-($dd->harga_barang->harga_beli * $dd->jumlah);

                                                        ?>
                                                    @endforeach
                                                @endforeach

                                                <td>
                                                    Rp.{{ number_format($ttl) }}
                                                </td>
                                              
                                                
                                               
                                            </tr>
                                        @endforeach
                                        
                                    </tbody>
                                </table>
                            </div>
                            <div class="dt-pagination">
                                <nav>
                                    {!! $datas->links() !!}
                                </nav>
                            </div>
                        </div>
                            @endif
                            
                            
                    </div>
                </div>
            </div>

        </div>
        
    </div>
</div>

@endsection
