@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li class="active-page"><a href="{{ url($url) }}">{{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <!-- <div class="section-header">
                    <h2>Table with simple header <code>.matmix-dt</code></h2>
                    <p>
                        This table is well styled and included edit delete options. You can use it in any table and this table support all bootstrap table classes like<code>.table, .table-striped, .table-hover, .table-bordered</code>
                    </p>
                </div> -->
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data {{ $title }}</h4>
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            @include('layouts.includes.search',['page'=>'barang'])
                            <div class="row" style="margin-bottom: 10px;">
                                <div class="col-md-3">
                                    <?php 
                                        $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                                        $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');

                                        $periode = (isset($_GET['periode']))?$_GET['periode']:false;
                                        $urutkan = (isset($_GET['urutkan']))?$_GET['urutkan']:'new';
                                        $kd_jenis = (isset($_GET['kd_jenis']))?$_GET['kd_jenis']:'';
                                        $kd_merek = (isset($_GET['kd_merek']))?$_GET['kd_merek']:'';
                                     ?>
                                    <a href="{{ url($url.'/cetak?type=cetak&menu='.$_GET['menu'].'&from='.$from.'&to='.$to) }}" target="_blank"><img src="{{ asset('images/btn_print2.png') }}" height="18" border="0" title="Cetak"/></a>
                                    | <a class="btn btn-default" href="{{ url($url.'/cetak?type=excel&menu='.$_GET['menu'].'&from='.$from.'&to='.$to.'&periode='.$periode.'&urutkan='.$urutkan.'&kd_jenis='.$kd_jenis.'&kd_merek='.$kd_merek) }}" target="_blank">Export ke Excel</a>  | <a href="{{ url($url) }}" class="btn btn-sm btn-warning">Kembali</a>
                                </div>
                                <div class="col-md-8">
                                    <form class="form-horizontal">
                                        <input type="hidden"  value="<?php echo (isset($_GET['s']))?$_GET['s']:''; ?>" name="s">
                                        <input type="hidden" name="menu" value="{{ $_GET['menu'] }}">

                                        <input type="hidden" name="urutkan" value="{{ $urutkan }}">
                                        <input type="hidden" name="kd_jenis" value="{{ $kd_jenis }}">
                                        <input type="hidden" name="kd_merek" value="{{ $kd_merek }}">
                                        <div class="form-group">
                                            <div class=" col-md-2">
                                                <input type="checkbox" name="periode" @if($periode) checked @endif><label> Filter Periode</label>
                                            </div>
                                            <div class=" col-md-4">
                                                <input type="date" name="from" class="form-control" placeholder="Dari Tanggal" value="{{ $from }}" required>
                                            </div>
                                            <div class=" col-md-4">
                                                <input type="date" name="to" class="form-control" placeholder="Sampai Tanggal" value="{{ $to }}" required>
                                            </div>
                                            <div class="col-md-2">
                                                <button class="btn btn-info">Tampil</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                
                            </div>
                            <div class="table-responsive" style="max-height: 100vh;overflow: scroll;">
                                
                                <table class="table table-striped table-hover table-bordered matmix-dt" id="tabel-barang-periode" >
                                    <thead>
                                        <tr>
                                       
                                            <th>
                                                No
                                            </th>
                                           
                                            <th>
                                                Kode Barang
                                            </th>
                                            <th>
                                                Barcode
                                            </th>
                                           <th>
                                               Nama Barang
                                           </th>
                                           <th>
                                               Stok Awal
                                           </th>
                                           <th>
                                               Stok Terjual
                                           </th>
                                            <th>
                                                Stok Tersedia
                                            </th>
                                           <th>
                                               Waktu Dibuat
                                           </th>
                                         
                                         
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $no = 1; ?>
                                        <?php 
                                            $stok_awal = 0;
                                            $harga_satuan = 0;
                                            $stok_terjual = 0;
                                            $total_harga = 0;
                                            $total_harga_terjual = 0;
                                            $stok_tersedia = 0;
                                            $total_harga_tersedia = 0;

                                         ?>
                                         <?php 
                                            $page = 0;
                                            if(isset($_GET['page']) && $_GET['page'] > 1){
                                                $page = $_GET['page']*10-10;
                                            }
                                            $no = 1*$page+1; 
                                        ?>
                                        @foreach($datas as $data)
                                            <tr>
                                                
                                                <td>
                                                    {{ $no++ }}
                                                </td>
                                                
                                                <td>
                                                    {{ $data->kd_barang }}
                                                </td>
                                                <td>
                                                    {{ $data->barcode }}
                                                </td>
                                                <td>
                                                    {{ $data->nm_barang }}
                                                </td>

                                                <td>
                                                    {{ $data->stok_awal }}
                                                </td>
                                                <?php $stok_awal += $data->stok_awal; ?>
                                                <td>
                                                    {{ $data->stok_terjual }}
                                                </td>
                                                <?php $stok_terjual += $data->stok_terjual; ?>
                                                <td>
                                                    {{ $data->stok_awal-$data->stok_terjual }}
                                                </td>
                                                <?php $stok_tersedia += $data->stok_awal-$data->stok_terjual; ?>
                                                <td>
                                                    {{ date('Y-m-d',strtotime($data->created_at)) }}
                                                </td>
                                              
                                                
                                               
                                            </tr>
                                            <tr style="background-color: #e0e0e0;color:black;">
                                       
                                                <td>
                                                    
                                                </td>

                                                <td>
                                                    
                                                </td>
                                               
                                                <td>
                                                    Harga Satuan
                                                </td>
                                               <td>
                                                    Total Harga
                                               </td>
                                               <td>
                                                   Total Harga Terjual
                                               </td>
                                               <td>
                                                   Total Harga Tersedia
                                               </td>
                                       
                                               <td >
                                                  
                                               </td>
                                               <td>
                                                   
                                               </td>
                                             
                                             
                                            </tr>
                                            @foreach($data->harga_barang as $harga)
                                                <tr style="background-color: #e0e0e0;color:black;">
                                           
                                                    <td>
                                                        
                                                    </td>

                                                    <td>
                                                        
                                                    </td>
                                                   
                                                    <td>
                                                        Rp.{{ number_format(floatval($harga->harga_jual)) }}
                                                        <?php $harga_satuan += floatval($harga->harga_jual); ?>
                                                    </td>
                                                   <td>
                                                        Rp.{{ number_format(floatval($harga->harga_jual)*$data->stok_awal) }}
                                                        <?php $total_harga += floatval($harga->harga_jual)*$data->stok_awal; ?>
                                                   </td>
                                                   <td>
                                                       Rp.{{ number_format(floatval($harga->harga_jual)*$data->stok_terjual) }}
                                                       <?php $total_harga_terjual += floatval($harga->harga_jual)*$data->stok_terjual ?>
                                                   </td>
                                                   <td>
                                                       Rp.{{ number_format(floatval($harga->harga_jual)*($data->stok_awal-$data->stok_terjual)) }}
                                                       <?php $total_harga_tersedia += floatval($harga->harga_jual)*($data->stok_awal-$data->stok_terjual) ?>
                                                   </td>
                                           
                                                   <td >
                                                      
                                                   </td>
                                                   <td></td>
                                                 
                                                 
                                                </tr>
                                            @endforeach
                                        @endforeach
                                        
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>Total Harga Satuan : {{ number_format($harga_satuan) }}</th>
                                            <th>Total Stok Awal : {{ $stok_awal }}</th>
                                            <th>Total Harga : {{ number_format($total_harga) }}</th>
                                            <th>Total Stok Terjual : {{ $stok_terjual }}</th>
                                            <th>Total Harga Terjual : {{ number_format($total_harga_terjual) }}</th>
                                            <th>Total Stok Tersedia : {{ $stok_tersedia }}</th>
                                            <th>Total Harga Tersedia : {{ number_format($total_harga_tersedia) }}</th>
                                            <th></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <div class="dt-pagination">
                                <nav>
                                    
                                </nav>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>

        </div>
        
    </div>
</div>

@endsection
