@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li class="active-page"><a href="{{ url($url) }}">{{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <!-- <div class="section-header">
                    <h2>Table with simple header <code>.matmix-dt</code></h2>
                    <p>
                        This table is well styled and included edit delete options. You can use it in any table and this table support all bootstrap table classes like<code>.table, .table-striped, .table-hover, .table-bordered</code>
                    </p>
                </div> -->
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data {{ $title }}</h4>
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            <div class="row">
                                <div class="col-md-4">
                                    <?php 
                                        $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                                        $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                                        $user = (isset($_GET['user']))?$_GET['user']:'';
                                     ?>
                                    <a href="{{ url($url.'/cetak?type=html&menu='.$_GET['menu'].'&from='.$from.'&to='.$to.'&user='.$user) }}" target="_blank"><img src="{{ asset('images/btn_print2.png') }}" height="18" border="0" title="Cetak ke Format HTML"/></a>
                                    | <a class="btn btn-default" href="{{ url($url.'/cetak?type=excel&menu='.$_GET['menu'].'&from='.$from.'&to='.$to) }}" target="_blank">Export ke Excel</a>  | <a href="{{ url($url) }}" class="btn btn-sm btn-warning">Kembali</a>
                                </div>
                                <div class="col-md-8">
                                    <form class="form-horizontal">
                                        <input type="hidden"  value="<?php echo (isset($_GET['s']))?$_GET['s']:''; ?>">
                                        <input type="hidden" name="menu" value="{{ $_GET['menu'] }}">
                                        <div class="form-group">
                                            
                                            <div class=" col-md-4">
                                                <input type="date" name="from" class="form-control" placeholder="Dari Tanggal" value="{{ $from }}" required>
                                            </div>
                                            <div class=" col-md-4">
                                                <input type="date" name="to" class="form-control" placeholder="Sampai Tanggal" value="{{ $to }}" required>
                                            </div>
                                            <div class="col-md-4">
                                                <select name="user" class="form-control select2">
                                                    <option value="">Pilih Semua</option>
                                                    @foreach($seconds as $supplier)
                                                        <option @if(isset($_GET['user']) && $_GET['user'] == $supplier->id) selected @endif value="{{ $supplier->id }}">{{ $supplier->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-md-4">
                                                <button class="btn btn-info">Tampil</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="table-responsive">
                                
                                <table class="table table-striped table-hover table-bordered matmix-dt">
                                    <thead>
                                        <tr>
                                       
                                            <th>
                                                No
                                            </th>
                                            <th>
                                                Nama
                                            </th>
                                            <th>
                                               No Jasa
                                           </th>
                                           <th>
                                               Tgl Penjualan
                                           </th>
                                           <th>
                                               Barang
                                           </th>
                                           <th>
                                               Qty
                                           </th>
                                           <th>
                                               Total
                                           </th>
                                         
                                         
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $no = 1; ?>
                                        <?php 
                                            $page = 0;
                                            if(isset($_GET['page']) && $_GET['page'] > 1){
                                                $page = $_GET['page']*10-10;
                                            }
                                            $no = 1*$page+1; 
                                        ?>
                                        
                                        @foreach($datas as $data)
                                            
                                            <tr>
                                                <td>
                                                    {{ $no++ }}
                                                </td>
                                                <td>
                                                    {{ @$data->jasa_root->user->name }}
                                                </td>
                                                <td>
                                                    {{ @$data->jasa_root->no_jasa }}
                                                </td>
                                                <td>
                                                    {{ @$data->jasa_root->created_at }}
                                                </td>
                                                <td>
                                                    {{ @$data->jasa}}
                                                </td>
                                                <td>
                                                    {{ @$data->qty}}
                                                </td>
                                                <td>
                                                    {{ $data->harga*$data->qty}}
                                                </td>
                                            </tr>
                                        @endforeach
                                        
                                    </tbody>
                                </table>
                            </div>
                            <div class="dt-pagination">
                                <nav>
                                    {!! $datas->links() !!}
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        
    </div>
</div>

@endsection
