@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">Transaksi</a>
                                </li>
                                <li class="active-page"><a href="{{ url($url) }}">{{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <!-- <div class="section-header">
                    <h2>Table with simple header <code>.matmix-dt</code></h2>
                    <p>
                        This table is well styled and included edit delete options. You can use it in any table and this table support all bootstrap table classes like<code>.table, .table-striped, .table-hover, .table-bordered</code>
                    </p>
                </div> -->
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data {{ $title }}</h4>
                        <div class="pull-right" style="padding: 10px;">
                           
                            <a href="{{ url($url.'/create') }}" class="btn  btn-info ">Tambah Data</a>
                        </div>
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            @include('layouts.includes.search')
                            <div class="table-responsive">
                                <button style="margin-bottom: 10px" class="btn btn-danger delete_all" data-url="{{ url($url.'/deleteAll') }}">Delete All Selected</button>
                                <table class="table table-striped table-hover table-bordered matmix-dt">
                                    <thead>
                                        <tr>
                                            <th class="tc-center">
                                                <input type="checkbox"  id="master">
                                            </th>
                                            <th>
                                                No
                                            </th>
                                           
                                            <th>
                                                No Jasa
                                            </th>
                                            <th>
                                                Tanggal Nota
                                            </th>
                                            <th>
                                                Tanggal Selesai
                                            </th>
                                            <th>
                                                Pelanggan
                                            </th>
                                            <th>
                                                Pembayaran
                                            </th>

                                            <th>
                                                Status
                                            </th>
                                           
                                         
                                            
                                            <th class="tc-center">
                                                Aksi
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($datas as $data)
                                            <tr>
                                                <td class="tc-center">
                                                    <input type="checkbox" class=" sub_chk" data-id="{{$data->no_jasa}}">
                                                </td>
                                                <td>
                                                    {{ $no++ }}
                                                </td>
                                                
                                                <td>
                                                    {{ $data->no_jasa }}
                                                </td>
                                                <td>
                                                    {{ date('Y-m-d',strtotime($data->created_at)) }}
                                                </td>
                                                <td>
                                                    {{ $data->tgl_jasa }}
                                                </td>
                                                
                                                <td>
                                                    {{ $data->nama_pelanggan }} / {{ $data->no_hp_pelanggan }}
                                                </td>

                                                <td>
                                                    {{ $data->pembayaran }}
                                                </td>

                                                <td>
                                                    @if($data->status == 0) Sedang Di Kerjakan @else Selesai Di Kerjakan @endif
                                                </td>
                                                
                                                <td class="tc-center">
                                                    <div class="btn-toolbar" role="toolbar">
                                                        <div class="btn-group" role="group">
                                                            <?php $link = url($url.'/'.$data->no_jasa.'/cetak-thermal'); ?>
                                                            
                                                            <a href="{{ url($url.'/'.$data->no_jasa.'/cetak') }}" class="btn btn-primary btn-sm" target="_blank" style="cursor:pointer;">Cetak</a>
                                                            <a href="{{ url($url.'/'.$data->no_jasa) }}" class="btn btn-success btn-sm ">Detail</a>
                                                            <a href="{{ url($url.'/'.$data->no_jasa.'/edit') }}" class="btn btn-warning btn-sm ">Edit</a>
                                                            <a href="#" class="btn btn-danger btn-sm m-user-delete" data-id="{{ $data->no_jasa }}" data-url="{{ $url }}">Delete</a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        
                                    </tbody>
                                </table>
                            </div>
                            <div class="dt-pagination">
                                <nav>
                                    {!! $datas->links() !!}
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        
    </div>
</div>



@endsection
