@extends('layouts.app')

@section('content')
<style type="text/css">
    .kasir {
        font-size: 12px;
    }
</style>
<div class="main-container kasir">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li  ><a href="{{ url($url) }}">{{ $title }}</a></li>
                                <li class="active-page" ><a href="{{ url($url) }}">Tambah Data {{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <form class="form-horizontal" method="post" action="{{ url($url) }}" id="myForm">
            <div class="row">
                <div class="col-md-12">
                    <div class="box-widget widget-module">
                        <div class="widget-head clearfix">
                            <span class="h-icon"><i class="fa fa-table"></i></span>
                            <h4>Data {{ $title }}</h4>
                            <div class="pull-right" style="padding: 10px;">
                             
                                <a href="{{ url($url) }}" class="btn  btn-warning ">Kembali</a>
                            </div>
                            
                        </div>
                        <div class="widget-container">
                            <div class="widget-block">
                                <div class="row">
                                    

                                    <div class="col-md-3" >
                                     
                                        
                                        @csrf

                                        

                                        <div class="form-group">
                                            <label style="text-align: left;" class="col-md-4 control-label">No : </label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control" name="no_jasa" placeholder="No Penjualaan" readonly="" value="{{ ++$kd }}">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label style="text-align: left;" class="col-md-4 control-label">Tanggal Selesai : </label>
                                            <div class=" col-md-8">
                                                <input type="date" class="form-control" name="tgl_jasa" value="{{ date('Y-m-d') }}">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label style="text-align: left;" class="col-md-4 control-label">Nama Pelanggan : </label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control" name="nama_pelanggan" maxlength="200" placeholder="Nama Pelanggan" value="{{ old('nama_pelanggan') }}">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label style="text-align: left;" class="col-md-4 control-label">No Hp Pelanggan : </label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control" name="no_hp_pelanggan" maxlength="30" placeholder="Nomor Hp Pelanggan" value="{{ old('no_hp_pelanggan') }}">
                                                
                                            </div>
                                        </div>

                                      



                                        <div class="form-group">
                                            <label style="text-align: left;" class="col-md-4 control-label">Pembayaran : </label>
                                            <div class=" col-md-8">
                                                <select class="form-control" required="" name="pembayaran" id="pembayaran">
                                                    
                                                    <option value="Cash">Cash</option>
                                                    <option value="Kredit">Kredit</option>
                                                    <option value="Transfer Cash">Transfer Cash</option>
                                                    <option value="Transfer Kredit">Transfer Kredit</option>
                                                </select>
                                                
                                            </div>
                                        </div>

                                        

                                        

                                        
                                        
                                    </div>
                                  

                                    <div class="col-md-9">
                                     
                                       <div class="row">
                                            <div class="col-md-3">
                                                <label>Nama Jasa</label>
                                            </div>
                                            <div class="col-md-2">
                                                <label>Harga</label>
                                            </div>
                                            <div class="col-md-2">
                                                <label>Qty</label>
                                            </div>
                                            <div class="col-md-2">
                                                <label>Diskon</label>
                                            </div>

                                            <div class="col-md-2">
                                                <label>Total Harga</label>
                                            </div>
                                          
                                        </div>
                                        
                                        <div id="list-contain">
                                            

                                        </div>
                                    
                                       
                                        <br>
                                        
                                        <div class="row">
                                            
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    
                                                    <div class="col-md-12">
                                                        <div class="form-actions">
                                                            <button type="button" class="btn btn-danger" id="add_row">Add List</button>
                                                            
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        
                                        
                                    </div>


                                    
                       
                                    

                                  
                                    
                                </div>
                                <hr style="border:1px solid black;">
                                <div class="form-group">
                                    <label style="text-align: left;" class="col-md-1 control-label">Keterangan : </label>
                                    <div class=" col-md-6">
                                        <textarea class="form-control" name="keterangan" placeholder="Keterangan Jasa">{{ old('no_hp_pelanggan') }}</textarea>
                                        
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group ">
                                            <label style="text-align: left;" class="col-md-3 control-label">Grand Total : </label>
                                            <div class=" col-md-6">
                                                <input type="text" class="form-control " id="grand-total" disabled="">
                                                
                                            </div>
                                        </div>
                                        <div class="form-group ">
                                            <label style="text-align: left;" class="col-md-3 control-label">Uang Bayar : </label>
                                            <div class=" col-md-6">
                                                <input type="number" step="0.01"  class="form-control " name="uang_bayar" id="uang_bayar" min="0" value="0" onkeyup="bayar()" onchange="bayar()">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group ">
                                            <label style="text-align: left;" class="col-md-3 control-label">Kembalian : </label>
                                            <div class=" col-md-6">
                                                <input type="text" class="form-control " id="kembalian" readonly="" disabled="">
                                                
                                            </div>
                                        </div>
                                        <div class="form-group">
                                                    
                                            <div class="col-md-12">
                                                <div class="form-actions">
                                                    <button type="submit" class="btn btn-primary">Tambah</button>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </div>     
                                </div>

                            </div>
                        </div>
                    </div>    
                </div>
                

            </div>

     
        </form>
        
    </div>
</div>

<div class="row list-jasa" id="list-harga" style="display: none;" data-harga="0">
    <div class="col-md-3">
        <div class="form-group">
            <input type="text" class="form-control nama" name="jasa[]" placeholder="Jasa" required="" style="font-size: 10px;">
            
        </div>
        
    </div>

    <div class="col-md-2">
        <div class="form-group">
            
            <div class=" col-md-12">
                <input type="text" placeholder="Harga" name="harga[]"  class="form-control harga" style="font-size: 10px;"  onchange="update_grand_total()" value="0">
                
            </div>
        </div>
    </div>

    <div class="col-md-2">
        <div class="form-group">
            
            <div class=" col-md-12">
                <input type="number" step="0.01" placeholder="Qty"  name="qty[]" class="form-control qty" required="" min="1" style="font-size: 10px;" value="1" onchange="update_grand_total()">
                
            </div>
        </div>
    </div>

    <div class="col-md-2">
        <div class="form-group">
            
            <div class=" col-md-12">
                <input type="number" step="0.01" placeholder="Diskon"  name="diskon[]" class="form-control diskon" required="" min="0" style="font-size: 10px;" value="0" onchange="update_grand_total()" >
                
            </div>
        </div>
    </div>

    <div class="col-md-2">
        <div class="form-group">
            
            <div class=" col-md-12">
                <strong class="total-harga">Rp.0</strong>
                
            </div>
        </div>
    </div>


    <div class="col-md-1">
        <div class="form-group">
            
            <div class=" col-md-12">
                <button type="button" data-id="list-harga-1" class="delete_row">X</button>
                
            </div>
        </div>
    </div>
</div>


<script src="{{ asset('js/app.js') }}"></script>

<script type="text/javascript">
    var grand_total = 0.0;

    function cek_harga(e) {
        var ttl = parseFloat($(e).val());
        $(e).parent().parent().parent().parent().find('.total-harga').html(ttl);
        update_grand_total();
    }

    function bayar() {
        $("#kembalian").val($("#uang_bayar").val() - grand_total);
    }
    $(document).ready(function ($) {
        $('#scan_barang').focus();

        $(document).on('submit','#myForm',function (e) {

            if(($("#pembayaran").val() == "Cash" || $("#pembayaran").val() == "Transfer Cash") && grand_total > $("#uang_bayar").val()){
                e.preventDefault();
                alert('Uang Pembayaran TIdak Cukup');
            } 
           
        });


        
        $(document).on('click','.delete_row',function (e) {
            
            $("#"+$(this).data('id')).remove();
            update_grand_total();
            
        });
    });

    function update_grand_total() {
        grand_total = 0.0;
        $('.list-jasa').each(function(index, el) {
            var harga = $(el).find('.harga').val();
            harga = harga-(harga*$(el).find('.diskon').val()/100)
            var ttl = parseFloat(harga*$(el).find('.qty').val());
            grand_total += ttl;
            
            $(el).find('.total-harga').html(ttl);
            
        });
        console.log(grand_total);
        $("#grand-total").val(grand_total);
    }
       
    
</script>
@endsection
