@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li class="active-page"><a href="{{ url($url) }}">{{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <!-- <div class="section-header">
                    <h2>Table with simple header <code>.matmix-dt</code></h2>
                    <p>
                        This table is well styled and included edit delete options. You can use it in any table and this table support all bootstrap table classes like<code>.table, .table-striped, .table-hover, .table-bordered</code>
                    </p>
                </div> -->
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data {{ $title }}</h4>
                        <!-- <div class="pull-right" style="padding: 10px;">
                           
                            <a href="{{ url($url.'/create') }}" class="btn  btn-info ">Tambah Data</a>
                        </div> -->
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            @include('layouts.includes.search')
                            <div class="table-responsive">
                                
                                <table class="table table-striped table-hover table-bordered matmix-dt">
                                    <thead>
                                        <tr>
                                         
                                            <th>
                                                No
                                            </th>
                                           
                                            <th>
                                                Nama
                                            </th>
                                           
                                            <th>
                                                Alamat
                                            </th>

                                            <th>
                                                Telp
                                            </th>
                                            
                                            <th class="tc-center">
                                                Aksi
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($datas as $data)
                                            <tr>
                                               
                                                <td>
                                                    {{ $no++ }}
                                                </td>
                                                
                                                <td>
                                                    {{ $data->nm_pelanggan }}
                                                </td>
                                              
                                                <td>
                                                    {{ $data->alamat }}
                                                </td>
                                                <td>
                                                    {{ $data->no_telepon }}
                                                </td>
                                                <td class="tc-center">
                                                    <div class="btn-toolbar" role="toolbar">
                                                        <div class="btn-group" role="group">
                                                            <a href="{{ url($url.'/'.$data->kd_pelanggan) }}" class="btn btn-success btn-sm ">Detail</a>
                                                            
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                        
                                    </tbody>
                                </table>
                            </div>
                            <div class="dt-pagination">
                                <nav>
                                    {!! $datas->links() !!}
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        
    </div>
</div>

@endsection
