@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li  ><a href="{{ url($url) }}">{{ $title }}</a></li>
                                <li class="active-page" ><a href="{{ url($url) }}">Detail Data {{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data {{ $title }}</h4>
                        <div class="pull-right" style="padding: 10px;">

                            <a href="{{ url($url) }}" class="btn  btn-warning ">Kembali</a>
                        </div>
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            <div class="row">
                                <div class="col-md-6">

                                    <form class="form-horizontal" method="post" action="{{ url($url) }}">
                                        @csrf
                                        
                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Nama Pelanggan</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control" name="nm_pelanggan" placeholder="Nama Pelanggan" value="{{ $data->nm_pelanggan }}" readonly="" disabled="">
                                                <input type="hidden" name="kd_pelanggan" value="{{ $data->kd_pelanggan }}">
                                            </div>
                                        </div>


                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Alamat</label>
                                            <div class=" col-md-8">
                                                <textarea class="form-control" name="alamat" placeholder="Alamat" readonly="" disabled="">{{ $data->alamat }}</textarea>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Telepon</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control phone-mask" name="no_telepon" value="{{ $data->no_telepon }}" readonly="" disabled="">
                                                
                                            </div>
                                        </div>

                                        <?php 
                                            $s = $data->bayar - $data->hutang;
                                            $sisa = "Sudah Lunas";
                                            if($s < 0){
                                                $sisa = abs($s);
                                            }

                                         ?>

                                        @if($s < 0)
                                            <div class="form-group">
                                                <label style="text-align: left;" class="col-md-4 control-label">Tanggal : </label>
                                                <div class=" col-md-8">
                                                    <input type="date" class="form-control" name="tgl_bayar_penjualan" value="{{ date('Y-m-d') }}">
                                                    
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="col-md-4 control-label">Sisa Hutang : </label>
                                                <div class=" col-md-8">
                                                    <input type="text" class="form-control" name="hutang" min="0" value="{{ $sisa }}" readonly="" disabled="">
                                                    
                                                </div>
                                            </div>

                                            <div class="form-group">
                                                <label class="col-md-4 control-label">Bayar : </label>
                                                <div class=" col-md-8">
                                                    <input type="text" class="form-control" name="uang_bayar" min="0" value="0" required="">
                                                    
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="col-md-4 control-label">&nbsp;</label>
                                                <div class="col-md-8">
                                                    <div class="form-actions">
                                                        <button type="submit" class="btn btn-primary">Bayar</button>
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                        @else
                                        <div class="form-group">
                                            <div class="col-md-4"></div>
                                            <label class="col-md-8 label label-success" style="font-size: 15px;">Sudah Lunas</label>
                                                                                    
                                        </div>
                                        @endif

                                        
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>    
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data Pembayaran</h4>
                        
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">
                            <div class="row">
                                <div class="col-md-12">

                                    <table class="table table-hover table-bordered">
                                      <tr>
                                        <th width="5%">No</th>
                                        <th width="30%">Tanggal</th>
                                        <th>Pembayaran</th>
                                    </tr>
                                    <?php 
                                    $no = 1; 
                                    $subtotal = 0;
                                    ?>
                                    @foreach($data->bayar_penjualan as $bp)
                                    <tr>
                                        <td><?php echo $no++; ?></td>
                                        <td>{{ $bp->tgl_bayar_penjualan }}</td>
                                        <td><?php echo "Rp. ".number_format($bp->uang_bayar); ?></td>  
                                    </tr>
                                    <?php $subtotal += $bp->uang_bayar ?>
                                    @endforeach
                                    <tr>
                                        <td colspan="2"><b>SubTotal : </b></td>
                                        <td><?php 
                                        
                                        echo "Rp. ".number_format($subtotal)." + (DP)"."Rp. ".number_format($data->hutang); ?></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2"><b>Total : </b></td>
                                        <td><?php echo "Rp. ".number_format($subtotal - $data->hutang); ?> </td>
                                    </tr>
                                    @if($s < 0)
                                        <tr>
                                            <td colspan="2"><b>Sisa Yang Belum Di Bayar : </b></td>
                                            <td><?php echo "Rp. ".number_format($sisa); ?> </td>
                                        </tr>
                                    @else
                                        <tr>
                                            <td colspan="3"><label class=" label label-success" style="font-size: 15px;">Sudah Lunas</label></td>
                                            
                                        </tr>
                                        <tr>
                                            <td colspan="2"><b>Sisa Pembayaran Hutang : </b></td>
                                            <td><?php echo "Rp. ".number_format($subtotal - $data->hutang); ?> </td>
                                        </tr>
                                    @endif
                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>    
        </div>    
    </div>

</div>
</div>

@endsection
