@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li class="active-page"><a href="{{ url($url) }}">{{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <!-- <div class="section-header">
                    <h2>Table with simple header <code>.matmix-dt</code></h2>
                    <p>
                        This table is well styled and included edit delete options. You can use it in any table and this table support all bootstrap table classes like<code>.table, .table-striped, .table-hover, .table-bordered</code>
                    </p>
                </div> -->
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data {{ $title }}</h4>
                        <div class="pull-right" style="padding: 10px;">
                            <a href="{{ url($url.'/export') }}" class="btn  btn-warning "><i class="fa fa-file-excel-o"></i> Export Excel</a>
                            <a href="{{ url($url.'/import') }}" class="btn  btn-success "><i class="fa fa-file-excel-o"></i> Import Excel</a>
                            <a href="{{ url($url.'/create') }}" class="btn  btn-info ">Tambah Data</a>
                        </div>
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">



                            @include('layouts.includes.search',['page'=>'barang'])
                           
                            <div class="table-responsive">

                                <button style="margin-bottom: 10px;float: left;" class="btn btn-danger delete_all" data-url="{{ url($url.'/deleteAll') }}">Delete All Selected</button>
                                
                                <table class="table table-striped table-hover table-bordered matmix-dt">
                                    <thead>
                                        <tr>   
                                            <th class="tc-center" rowspan="2">
                                                <input type="checkbox"  id="master">
                                            </th>
                                            <th rowspan="2">No</th> <!-- column 1 -->
                                            <th rowspan="2">Kode</th> <!-- column 1 -->
                                            <th rowspan="2">Barcode</th> <!-- column 1 -->
                                            <th rowspan="2">Nama Barang</th> <!-- column 1 -->

                                            <th colspan="4"><center>INFO STOK<center></th>

                                                <th rowspan="2">Satuan Stok</th>
                                                <th rowspan="2"><center>Aksi</center></th>

                                            </tr>
                                            <tr>
                                                <th>Stok</th> <!-- column 2 -->
                                                <th>Opname</th> <!-- column 3 -->
                                                <th>Min</th> <!-- column 4 -->
                                                <th>Max</th> <!-- column 5 -->
                                                {{-- <th>Total</th> --}}

                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 
                                            $page = 0;
                                            if(isset($_GET['page']) && $_GET['page'] > 1){
                                                $page = $_GET['page']*10-10;
                                            }
                                            $no = 1*$page+1; 
                                            ?>
                                            @foreach($datas as $data)
                                            <tr>
                                                <td class="tc-center">
                                                    <input type="checkbox" class=" sub_chk" data-id="{{$data->kd_barang}}">
                                                </td>
                                                <td>
                                                    {{ $no++ }}
                                                </td>
                                                <td>
                                                    {{ $data->kd_barang }}
                                                </td>
                                                <td >
                                                    <a target="_blank" href="{{ url($url.'/'.$data->kd_barang.'/barcode') }}">
                                                        <img src="data:image/png;base64,{!! DNS1D::getBarcodePNG($data->barcode, 'C128',1,40) !!}" alt="barcode"   />
                                                    </a>

                                                    <p>{{ $data->barcode }}</p>
                                                    <!--<a target="_blank" href="{{ url($url.'/'.$data->kd_barang.'/barcode') }}" class="btn btn-info"> Print Barcode </a>-->
                                                </td>
                                                <td>
                                                    {{ $data->nm_barang }}
                                                </td>

                                                <td>
                                                    <b>{{ $data->stok }}</b>
                                                </td>

                                                <td>
                                                    <b>{{ $data->stok_opname }}</b>
                                                </td>

                                                <td>
                                                    <b>{{ $data->stok_minimal }}</b>
                                                </td>

                                                <td>
                                                    <b>{{ $data->stok_maksimal }}</b>
                                                </td>

                                                {{-- <td> --}}
                                                    <?php   
                                                    $stok = $data->stok;
                                                    $op = $data->stok_opname;
                                                    $hasil = ($stok + $op); 
                                                    ?>
                                                    {{-- {{ $hasil }}
                                                </td> --}}
                                                <td>
                                                    {{ $data->satuan_stok->nm_satuan }}
                                                </td>
                                                <td class="tc-center">
                                                    <div class="btn-toolbar" role="toolbar">
                                                        <div class="btn-group" role="group">
                                                            <a href="#" class="btn btn-success btn-sm lihat_harga" data-kode="{{ $data->kd_barang }}" data-toggle="modal" data-target="#lihat_harga">Harga</a>
                                                            <a href="{{ url($url.'/'.$data->kd_barang.'/edit') }}" class="btn btn-warning btn-sm ">Edit</a>
                                                            <a href="#" class="btn btn-danger btn-sm m-user-delete" data-id="{{ $data->kd_barang }}" data-url="{{ $url }}">Delete</a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            @endforeach

                                        </tbody>
                                    </table>
                                </div>
                                <div class="dt-pagination">
                                    <nav>
                                        {!! $datas->links() !!}
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>

    <div id="lihat_harga" class="modal fade" role="dialog">
      <div class="modal-dialog modal-lg">

        <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title">Harga Barang</h4>
        </div>
        <div class="modal-body" >
        <!-- <div class="row">
            <div class="col-md-6">
            </div>
            <div class="col-md-6">
                <form class="form-horizontal">
                    <div class="form-group">
                        <label class="col-md-6 control-label">Search:</label>
                        <div class=" col-md-6">
                            <input class="form-control search" type="text" placeholder="Search" name="s" value="<?php echo (isset($_GET['s']))?$_GET['s']:''; ?>">
                        </div>
                    </div>
                </form>
            </div>
        </div> -->
        <div class="row" id="list-data">

        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
    </div>
</div>

</div>
</div>

<script src="{{ asset('js/app.js') }}"></script>
<script type="text/javascript">
    $(document).on('click','.lihat_harga',function (e) {
        $("#list-data").html("");
        $.ajax({
            url: '{{ url("api/harga_barang") }}/'+$(this).data('kode'),
            type: 'GET',
            
            success: function (data) {
                $("#list-data").html(data);
                // $(".search")[0].focus();
            }
        });
    });
</script>
@endsection
