@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url($url) }}">{{ $title }}</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">{{ $menu }}</a>
                                </li>
                                <li  ><a href="{{ url($url) }}">{{ $title }}</a></li>
                                <li class="active-page" ><a href="{{ url($url) }}">Edit Data {{ $title }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <form class="form-horizontal" method="post" action="{{ url($url.'/'.$data->kd_barang) }}" enctype="multipart/form-data">
            <input type="hidden" name="_method" value="PUT">
            <div class="row">
                <div class="col-md-12">
                    <div class="box-widget widget-module">
                        <div class="widget-head clearfix">
                            <span class="h-icon"><i class="fa fa-table"></i></span>
                            <h4>Data {{ $title }}</h4>
                            <div class="pull-right" style="padding: 10px;">
                               
                                <a href="{{ url($url) }}" class="btn  btn-warning ">Kembali</a>
                            </div>
                            
                        </div>
                        <div class="widget-container">
                            <div class="widget-block">
                                <div class="row">
                                    
                                    <div class="col-md-6">
                                       
                                        
                                        @csrf
                                        <div class="form-group">
                                            <label class="col-md-4">Gambar Barang</label>
                                            <div class="col-md-8">
                                                <img src="{{ url('images/barang/'.$data->gambar_barang) }}" style="max-width: 100%;">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Gambar Barang</label>
                                            <div class=" col-md-8">
                                                <input type="file" class="form-control" onchange="checkFile(event,['jpg','jpeg','png'])" name="gambar_barang" placeholder="Gambar Barang">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Nama Barang</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control" name="nm_barang" placeholder="Nama Barang" value="{{ $data->nm_barang }}">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Barcode</label>
                                            <div class=" col-md-8">
                                                <input type="text" class="form-control" name="barcode" placeholder="Barcode" value="{{ $data->barcode }}">
                                                
                                            </div>
                                        </div>




                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Jenis</label>
                                            <div class=" col-md-8">
                                                <select class="form-control select2" required="" name="kd_jenis">
                                                    <option>Pilih Jenis</option>
                                                    @foreach($jeniss as $jenis)
                                                    <option value="{{ $jenis->kd_jenis }}" @if($data->kd_jenis == $jenis->kd_jenis) selected @endif>{{ $jenis->nm_jenis }}</option>
                                                    @endforeach
                                                </select>
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Merek</label>
                                            <div class=" col-md-8">
                                                <select class="form-control select2" required="" name="kd_merek">
                                                    <option>Pilih Merek</option>
                                                    @foreach($mereks as $merek)
                                                    <option value="{{ $merek->kd_merek }}" @if($data->kd_merek == $merek->kd_merek) selected @endif>{{ $merek->nm_merek }}</option>
                                                    @endforeach
                                                </select>
                                                
                                            </div>
                                        </div>

                                        
                                        
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Satuan Stok</label>
                                            <div class=" col-md-8">
                                                <select class="form-control select2" name="kd_satuan_stok" required>
                                                    <option value="">Pilih Satuan Stok</option>
                                                    @foreach($satuans as $satuan)
                                                    <option value="{{ $satuan->kd_satuan }}" @if($data->kd_satuan_stok == $satuan->kd_satuan) selected @endif>{{ $satuan->nm_satuan }}</option>
                                                    @endforeach
                                                </select>
                                                
                                            </div>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Stok</label>
                                            <div class=" col-md-8">
                                                <input type="number" step="0.01"  class="form-control" name="stok" placeholder="Stok" value="{{ $data->stok }}">
                                                
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Stok Opname</label>
                                            <div class=" col-md-8">
                                                <input type="number" step="0.01"  class="form-control" name="stok_opname" placeholder="Stok Opname" value="{{ $data->stok_opname }}">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Stok Minimal</label>
                                            <div class=" col-md-8">
                                                <input type="number" step="0.01"  class="form-control" name="stok_minimal" placeholder="Stok Minimal" value="{{ $data->stok_minimal }}">
                                                
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="col-md-4 control-label">Stok Maksimal</label>
                                            <div class=" col-md-8">
                                                <input type="number" step="0.01"  class="form-control" name="stok_maksimal" placeholder="Stok Maksimal" value="{{ $data->stok_maksimal }}">
                                                
                                            </div>
                                        </div>

                                        
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>    
                </div>
                

            </div>

            <style type="text/css">
            .list-harga input,.list-harga select {
                font-size: 12px;
            }
        </style>
        <div class="row">
            <div class="col-md-12">
                
                <div class="box-widget widget-module ">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-bars"></i></span>
                        <h4 class="widget-collapse waves-effect w-collapse">Petunjuk (klik Untuk Membuka Petunjuk Pengisian Harga Barang)</h4>
                        <ul class="widget-action-bar pull-right">
                            <li><span class="widget-collapse waves-effect w-collapse"><i class="fa fa-angle-down"></i></span>
                            </li>
                            
                        </ul>
                    </div>
                    <div class="widget-container bg-danger" style="display: none;">
                        <div class="widget-block">
                            <p><strong>Satuan Beli</strong> = satuan yang akan di gunakan saaat pembelian</p>
                            <p><strong>Jumlah per satuan beli</strong> = jumlah stok yang akan di tambah setiap pembelian dengan satuan beli yang di pilih (contoh : menambah 21 Pcs ke stok barang jika membeli 1 Lusin)</p>
                            <p><strong>Harga Beli</strong> = Harga beli per satuan barang di pembelian</p>    
                            <p><strong>Minimal Penjualan</strong> = minimal jumlah penjualan untuk harga jual (contoh : 1 barang = 1000,5 barang = 4500,dll)</p>
                            <p><strong>Jumlah per satuan jual</strong> = jumlah stok yang akan di kurang setiap penhualan barang dengan satuan jual yang di pilih (contoh : mengurang 21 Pcs dari stok barang jika menjual 1 Lusin</p>
                            <p><strong>Harga Jual</strong> = Harga jual per satuan barang di penjualan (contoh : 1 barang = 1000,5 barang = 4500,dll)</p>
                            <p><strong>Diskon</strong> = diskon harga jual dalam persen</p>
                        </div>
                    </div>
                </div>


                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data Harga {{ $title }}</h4>
                        
                    </div>
                    <div class="widget-container">
                        <div class="widget-block">

                            <div id="list-contain">
                                <div class="row" style="font-size: 12px;">
                                    <div class="col-md-1">
                                        <label>Satuan Beli</label>
                                    </div>
                                    <div class="col-md-1">
                                        <label title="Jumlah per satuan yang akan di tambah ke stok barang saat pembelian">Jumlah per satuan beli</label>
                                    </div>

                                    <div class="col-md-2">
                                        <label>Harga Beli</label>
                                    </div>

                                    
                                    <div class="col-md-1">
                                        <label>Satuan Jual</label>
                                    </div>

                                    <div class="col-md-1">
                                        <label>Minimal Penjualan</label>
                                    </div>

                                    <div class="col-md-1">
                                        <label title="Jumlah per satuan yang akan di kurang ke stok barang saat penjualan">Jumlah per satuan jual</label>
                                    </div>

                                    <div class="col-md-2">
                                        <label>Harga Jual</label>
                                    </div>

                                    <div class="col-md-2">
                                        <label>Diskon (%)</label>
                                    </div>
                                </div>
                                
                                @foreach($data->harga_barang()->orderBy('id','ASC')->get() as $harga)

                                <div class="row list-harga" id="list-harga-{{ $no }}">
                                    <input type="hidden" name="id_harga_barang[]" value="{{ $harga->id }}">
                                    <div class="col-md-1">
                                        <div class="form-group">
                                            
                                            <select  required="" name="kd_satuan_beli[]" class="col-md-10" style="padding: 0;">
                                                <option value="">Pilih Satuan Beli</option>
                                                @foreach($satuans as $satuan)
                                                <option value="{{ $satuan->kd_satuan }}" @if($satuan->kd_satuan == $harga->kd_satuan_beli) selected @endif>{{ $satuan->nm_satuan }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>



                                    <div class="col-md-1">
                                        <div class="form-group">
                                            
                                            <div class=" col-md-12">
                                                <input type="number" step="0.01"  class="form-control" name="jumlah_persatuan_beli[]" placeholder="Jumlah Per-satuan beli" value="{{ $harga->jumlah_persatuan_beli }}" required>
                                                
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-2">
                                        <div class="form-group">
                                            
                                            <div class=" col-md-12">
                                                <input type="number" step="0.01"  class="form-control" name="harga_beli[]" placeholder="Minimal Penjualan" value="{{ $harga->harga_beli }}">
                                                
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-md-1">
                                        <div class="form-group">
                                            
                                            <select  required="" name="kd_satuan_jual[]" class="col-md-10" style="padding: 0;">
                                                <option value="">Pilih Satuan Jual</option>
                                                @foreach($satuans as $satuan)
                                                <option value="{{ $satuan->kd_satuan }}" @if($satuan->kd_satuan == $harga->kd_satuan_jual) selected @endif>{{ $satuan->nm_satuan }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-1">
                                        <div class="form-group">
                                            
                                            <div class=" col-md-12">
                                                <input type="number" step="0.01"  class="form-control" name="beli_isi[]" placeholder="Beli Isi" value="{{ $harga->beli_isi }}" required>
                                                
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-1">
                                        <div class="form-group">
                                            
                                            <div class=" col-md-12">
                                                <input type="number" step="0.01"  class="form-control" name="jumlah_persatuan_jual[]" placeholder="Jumlah Per-satuan jual" value="{{ $harga->jumlah_persatuan_jual }}" required>
                                                
                                            </div>
                                        </div>
                                    </div>

                                    

                                    

                                    

                                    

                                    <div class="col-md-2">
                                        <div class="form-group">
                                            
                                            <div class=" col-md-12">
                                                <input type="number" step="0.01"  class="form-control" name="harga_jual[]" placeholder="Harga Jual" value="{{ $harga->harga_jual }}">
                                                
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-1">
                                        <div class="form-group">
                                            
                                            <div class=" col-md-12">
                                                <input type="number" step="0.01"  class="form-control" name="diskon[]" placeholder="Disc" value="{{ $harga->diskon }}" required>
                                                
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-1">
                                        <div class="form-group">
                                            
                                            <div class=" col-md-12">
                                                <button type="button" data-id="list-harga-{{ $no }}" class="delete_row">X</button>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php $no++; ?>
                                @endforeach

                            </div>

                            <div class="row">
                                
                                <div class="col-md-2">
                                    <div class="form-group">
                                        
                                        <div class="col-md-12">
                                            <div class="form-actions">
                                                <button type="button" class="btn btn-default" id="add_row">Add List</button>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                
                                <div class="col-md-2">
                                    <div class="form-group">
                                        
                                        <div class="col-md-12">
                                            <div class="form-actions">
                                                <button type="submit" class="btn btn-primary">Edit</button>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                
                                
                            </div>
                        </div>
                    </div>
                </div>    
            </div>
            

        </div>
    </form>
    
</div>
</div>

<div class="row " id="list-harga" style="display: none;">
    <div class="col-md-1">
        <div class="form-group">
            <select   name="kd_satuan_beli[]" required class="col-md-10" style="padding: 0;">
                <option value="">Pilih Satuan Beli</option>
                @foreach($satuans as $satuan)
                <option value="{{ $satuan->kd_satuan }}">{{ $satuan->nm_satuan }}</option>
                @endforeach
            </select>
            
        </div>
    </div>

    <div class="col-md-1">
        <div class="form-group">
            
            <div class=" col-md-12">
                <input type="number" step="0.01"  class="form-control" name="jumlah_persatuan_beli[]" placeholder="Jumlah Per-satuan beli" value="0" required>
                
            </div>
        </div>
    </div>
    

    <div class="col-md-2">
        <div class="form-group">
            
            <div class=" col-md-12">
                <input type="number" step="0.01"  class="form-control" name="harga_beli[]" placeholder="Harga Beli" min="0" value="0" required>
                
            </div>
        </div>
    </div>

    <div class="col-md-1">
        <div class="form-group">
            
            <select required=""  name="kd_satuan_jual[]" required class="col-md-10" style="padding: 0;">
                <option value="">Pilih Satuan Jual</option>
                @foreach($satuans as $satuan)
                <option value="{{ $satuan->kd_satuan }}">{{ $satuan->nm_satuan }}</option>
                @endforeach
            </select>
        </div>
    </div>

    <div class="col-md-1">
        <div class="form-group">
            
            <div class=" col-md-12">
                <input type="number" step="0.01"  class="form-control" name="beli_isi[]" placeholder="Minimal Penjualan" value="0" required>
                
            </div>
        </div>
    </div>

    <div class="col-md-1">
        <div class="form-group">
            
            <div class=" col-md-12">
                <input type="number" step="0.01"  class="form-control" name="jumlah_persatuan_jual[]" placeholder="Jumlah Per-satuan jual" value="0" required>
                
            </div>
        </div>
    </div>

    <div class="col-md-2">
        <div class="form-group">
            
            <div class=" col-md-12">
                <input type="number" step="0.01"  class="form-control" name="harga_jual[]" placeholder="Harga Jual" min="0" value="0" required>
                
            </div>
        </div>
    </div>

    <div class="col-md-1">
        <div class="form-group">
            
            <div class=" col-md-12">
                <input type="number" step="0.01"  class="form-control" name="diskon[]" placeholder="Disc" required min="0" value="0">
                
            </div>
        </div>
    </div>

    <div class="col-md-1">
        <div class="form-group">
            
            <div class=" col-md-12">
                <button type="button" data-id="list-harga-1" class="delete_row">X</button>
                
            </div>
        </div>
    </div>
</div>
@endsection
