@extends('layouts.app')

@section('content')
<div class="main-container">
    <div class="container-fluid">
        <div class="page-breadcrumb">
            <div class="row">
                <div class="col-md-7">
                    <div class="page-breadcrumb-wrap">

                        <div class="page-breadcrumb-info">
                            <h2 class="breadcrumb-titles"><a href="{{ url('backup') }}">Backup Database</a></h2>
                            <ul class="list-page-breadcrumb">
                                <li><a href="#">Backup</a>
                                </li>
                                <li class="active-page"><a href="{{ url('backup') }}">Backup Database</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-5">
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <!-- <div class="section-header">
                    <h2>Table with simple header <code>.matmix-dt</code></h2>
                    <p>
                        This table is well styled and included edit delete options. You can use it in any table and this table support all bootstrap table classes like<code>.table, .table-striped, .table-hover, .table-bordered</code>
                    </p>
                </div> -->
                <div class="box-widget widget-module">
                    <div class="widget-head clearfix">
                        <span class="h-icon"><i class="fa fa-table"></i></span>
                        <h4>Data Backup Database</h4>
                        <div class="pull-right" style="padding: 10px;">
                           
                            <a id="create-new-backup-button" href="{{ url('backup/create') }}" class="btn btn-primary pull-right"
                               style="margin-bottom:2em;"><i
                                    class="fa fa-plus"></i> Create New Backup
                            </a>
                        </div>
                        
                    </div>

                    <?php 
                        use Spatie\Backup\Helpers\Format;
                        function humanFilesize($size, $precision = 2) {

                            $units = array('B','kB','MB','GB','TB','PB','EB','ZB','YB');
                            $step = 1024;
                            $i = 0;

                            while (($size / $step) > 0.9) {
                                $size = $size / $step;
                                $i++;
                            }
                            
                            return round($size, $precision).$units[$i];
                        } ?>
                    <div class="widget-container">
                        <div class="widget-block">
                           
                            <div class="table-responsive">
                                
                                @if (count($backups))

                                <table class="table table-striped table-bordered matmix-dt" id="example1">
                                    <thead>
                                    <tr>
                                        <th>File</th>
                                        <th>Size</th>
                                        <th>Waktu Di Buat</th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($backups as $backup)
                                        <tr>
                                            <td>{{ $backup['file_name'] }}</td>
                                            <td>{{ Format::humanReadableSize($backup['file_size']) }}</td>
                                            <td>{{ $backup['time']->format('Y-m-d H:i:s') }}</td>
                                            <td class="text-right">
                                                <a class="btn btn-xs btn-default"
                                                   href="{{ url('backup/download/'.$backup['file_name']) }}"><i
                                                        class="fa fa-cloud-download"></i> Download</a>
                                                <!-- <a class="btn btn-xs btn-info"
                                                   href="{{ url('backup/restore/'.$backup['file_name']) }}"><i
                                                        class="fa fa-cloud-download"></i> Restore</a> -->
                                                <!-- <a class="btn btn-xs btn-danger" data-button-type="delete"
                                                   href="{{ url('backup/delete/'.$backup['file_name']) }}"><i class="fa fa-trash-o"></i>
                                                    Delete</a> -->
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            @else
                                <div class="well">
                                    <h4>There are no backups</h4>
                                </div>
                            @endif
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>

        </div>
        
    </div>
</div>

@endsection
