<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable;

    protected $guarded = [];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    // protected $casts = [
    //     'email_verified_at' => 'datetime',
    // ];

    public function level()
    {
        return $this->belongsTo(Level::class,'level_id');
    }

    public function check_menu($nama_menu,$aksi)
    {
        $check = $this->level->level_menu;

        foreach ($check as $value) {
            if($value->nm_menu == $nama_menu && $value->aksi_menu == $aksi){
                return true;
            }
        }
        return false;
    }

    public function penjualan()
    {
        return $this->hasMany(Penjualan::class,'id_user');
    }
}
