<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Supplier extends Model
{
    protected $guarded = [];
    protected $primaryKey = "kd_supplier";
    public $incrementing = false;

    public function pembelian()
    {
    	return $this->hasMany(Pembelian::class,'kd_supplier');
    }

    public function bayar_pembelian()
    {
    	return $this->hasMany(BayarPembelian::class,'kd_supplier');
    }

    public function getHutangAttribute()
    {
    	$pm = $this->pembelian;
    	$ttl_htng = 0;
    	foreach ($pm as $dpm) {
            if($dpm->keterangan == "Kredit"){
                
                foreach ($dpm->detail as $dd) {
                    $ppn = 0;
                    $hargaDiskon= $dd->harga_barang->harga_beli - ( $dd->harga_barang->harga_beli * $dd->diskon/100);
                    if($dpm->ppn == 1){
                      $ppn = ($dd->jumlah * $hargaDiskon) * 10/100;
                    }
                    $ttl_htng += (($dd->jumlah * $hargaDiskon) + $ppn);
                }
                $ttl_htng -= $dpm->dp;
            }
        		
    	}
    	return $ttl_htng;
    }

    public function getBayarAttribute()
    {	
    	if(!isset($this->bayar_pembelian)){
    		return 0;
    	}
    	$by = $this->bayar_pembelian;
    	$ttl_byr = 0;
    	foreach ($by as $dd) {
    		$ttl_byr += $dd->uang_bayar;
    	}
    	return $ttl_byr;
    }
}
