<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ReturPenjualan extends Model
{
    protected $guarded = [];
    protected $primaryKey = "no_retur_penjualan";
    public $incrementing = false;

    public function pelanggan()
    {
    	return $this->belongsTo(Pelanggan::class,'kd_pelanggan');
    }

    public function user()
    {
        return $this->belongsTo(User::class,'id_user');
    }

    public function detail()
    {
    	return $this->hasMany(DetailReturPenjualan::class,'no_retur_penjualan');
    }

    public function getJumlahAttribute()
    {
        $jumlah = 0;
        foreach ($this->detail as $e) {
            $jumlah += $e->jumlah;
        }
        return $jumlah;
    }

    public function delete(){
        $this->detail()->delete();
        parent::delete();
    }
}
