<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ReturPembelian extends Model
{
    protected $guarded = [];
    protected $primaryKey = "no_retur_pembelian";
    public $incrementing = false;

    public function supplier()
    {
    	return $this->belongsTo(Supplier::class,'kd_supplier');
    }

    public function user()
    {
        return $this->belongsTo(User::class,'id_user');
    }
    
    public function detail()
    {
    	return $this->hasMany(DetailReturPembelian::class,'no_retur_pembelian');
    }

    public function getJumlahAttribute()
    {
        $jumlah = 0;
        foreach ($this->detail as $e) {
            $jumlah += $e->jumlah;
        }
        return $jumlah;
    }

    public function delete(){
        $this->detail()->delete();
        parent::delete();
    }
}
