<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Pelanggan extends Model
{
    protected $guarded = [];
    protected $primaryKey = "kd_pelanggan";
    public $incrementing = false;

    public function penjualan()
    {
    	return $this->hasMany(Penjualan::class,'kd_pelanggan');
    }

    public function bayar_penjualan()
    {
    	return $this->hasMany(BayarPenjualan::class,'kd_pelanggan');
    }

    public function poin()
    {
        return $this->hasMany(Poin::class,'kd_pelanggan', 'kd_pelanggan');
    }

    public function getHutangAttribute()
    {
    	$pm = $this->penjualan;
    	$ttl_htng = 0;
    	foreach ($pm as $dpm) {
            if($dpm->keterangan == "Kredit"){
                foreach ($dpm->detail as $dd) {
                    $ttl_htng += $dd->jumlah * $dd->harga_barang->harga_jual;
                }
            }
            $ttl_htng -= $dpm->uang_bayar;
                
    	}
    	return $ttl_htng;
    }

    public function getBayarAttribute()
    {	
    	if(!isset($this->bayar_penjualan)){
    		return 0;
    	}
    	$by = $this->bayar_penjualan;
    	$ttl_byr = 0;
    	foreach ($by as $dd) {
    		$ttl_byr += $dd->uang_bayar;
    	}
    	return $ttl_byr;
    }

    public function city_root(){
        return $this->belongsTo(City::class, 'city_id', 'city_id');
    }

}
