<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Jasa extends Model
{
    protected $guarded = [];
    protected $primaryKey = "no_jasa";
    public $incrementing = false;
    protected $appends = ['jumlah'];

    public function pelanggan()
    {
    	return $this->belongsTo(Pelanggan::class,'kd_pelanggan');
    }

    public function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }


    public function detail()
    {
    	return $this->hasMany(DetailJasa::class,'no_jasa');
    }

    public function getJumlahAttribute()
    {
        $harga = 0;
        foreach ($this->detail as $e) {
            $harga += $e->harga*$e->qty;
        }
        return $harga;
    }

    public function bayar_jasa()
    {
        return $this->hasMany(BayarJasa::class,'no_jasa');
    }

    public function getBayarHutangAttribute()
    {
        $uang_bayar = 0;
        foreach ($this->bayar_jasa as $e) {
            $uang_bayar += $e->uang_bayar;
        }
        return $uang_bayar+$this->uang_bayar;
    }





    public function delete(){
        $this->detail()->delete();
        parent::delete();
    }
}
