<?php

namespace App\Imports;

use App\Pelanggan;
use Maatwebsite\Excel\Concerns\ToModel;

class PelangganImport implements ToModel
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {   
        if(isset($row[0]) && $row[0] != "No Agen"){
            $l = Pelanggan::orderBy('kd_pelanggan','DESC')->first();
            $kd = "P001";
            if($l){
                $kd = $l->kd_pelanggan;
            }
            return new Pelanggan([
                'kd_pelanggan'=>++$kd,
                'no_anggota'=>sprintf("%06d", $row[0]),
                'nm_pelanggan'=>$row[2],
                'nm_pemilik'=>$row[1],
                'alamat'=>$row[3],
                'no_telepon'=>$row[4],
                'no_wa'=>$row[5]

            ]);
        }
            
    }
}
