<?php

namespace App\Imports;

use App\Barang;
use App\Jenis;
use App\Kategori;
use App\Merek;
use App\Satuan;
use App\HargaBarang;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithCalculatedFormulas;



class BarangsImport implements ToModel,WithCalculatedFormulas
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {   
       
        if(isset($row[1]) &&  strtolower($row[0]) != 'barcode' && isset($row[2]) && isset($row[3]) && isset($row[4]) && isset($row[5])){
            $cb = Barang::where('nm_barang',$row[1])->first();
            $kd_kategori = "K001";
                $ck = Kategori::where('nm_kategori',$row[2])->first();
                if($ck){
                    $kd_kategori = $ck->kd_kategori;
                } else {
                    $l = Kategori::orderBy('kd_kategori','DESC')->first();
                    $kd = "K000";
                    if($l){
                        $kd = $l->kd_kategori;
                    }
                    $kd_Kategori = Kategori::create(['kd_kategori'=>++$kd,'nm_kategori'=>$row[2]]);
                }


                $kd_jenis = "K001";
                $cj = Jenis::where('nm_jenis',$row[3])->first();
                if($cj){
                    $kd_jenis = $cj->kd_jenis;
                } else {
                    $l = Jenis::orderBy('kd_jenis','DESC')->first();
                    $kd = "K000";
                    if($l){
                        $kd = $l->kd_jenis;
                    }
                    $kd_jenis = Jenis::create(['kd_jenis'=>++$kd,'kd_kategori'=>$kd_kategori,'nm_jenis'=>$row[3]])->kd_jenis;
                }

                $cm = Merek::where('nm_merek',$row[4])->first();
                $kd_merek = "M001";
                if($cm){
                    $kd_merek = $cm->kd_merek;
                } else {
                    $l = Merek::orderBy('kd_merek','DESC')->first();
                    $kd = "M000";
                    if($l){
                        $kd = $l->kd_merek;
                    }
                    $kd_merek = Merek::create(['kd_merek'=>++$kd,'nm_merek'=>$row[4]])->kd_merek;
                }

                $cm = Satuan::where('nm_satuan',$row[5])->first();
                $kd_satuan = "N001";
                if($cm){
                    $kd_satuan = $cm->kd_satuan;
                } else {
                    $l = Satuan::orderBy('kd_satuan','DESC')->first();
                    $kd = "N000";
                    if($l){
                        $kd = $l->kd_satuan;
                    }
                    $kd_satuan = Satuan::create(['kd_satuan'=>++$kd,'nm_satuan'=>$row[5]])->kd_satuan;
                }
            if($cb){
                if(isset($row[10]) || isset($row[11])){
                    $harga = [
                        'kd_barang'=>$cb->kd_barang,
                        'kd_satuan_beli'=>$kd_satuan,
                        'jumlah_persatuan_beli'=>1,
                        'jumlah_persatuan_jual'=>1,
                        'beli_isi'=>1,
                        'kd_satuan_jual'=>$kd_satuan,
                        'harga_beli'=>($row[10] != null)?$row[10]:0,
                        'harga_jual'=>($row[11] != null)?$row[11]:(($row[10] != null)?$row[10]:0),
                        'diskon'=>0
                    ];
                    HargaBarang::create($harga);
                }
                return $cb;
            } else {

                $l = Barang::orderBy('kd_barang','DESC')->first();
                $kd = "B000000";
                $bar = "BAR000001";
                if($l){
                    $kd = $l->kd_barang;
                    if(strpos($l->barcode, 'BAR') !== false){
                        $bar = $l->barcode;
                    }
                    
                }
                $kd_barang = ++$kd;


                $barcode = ($row[0] != null && isset($row[0]) && strlen(trim($row[0])) > 0)?$row[0]:++$bar;
                $nm_barang = $row[1];

                
                $barang = Barang::create([
                    'kd_barang'=>$kd_barang,
                    'barcode'=>$barcode,
                    'nm_barang'=>$nm_barang,
                    'kd_jenis'=>$kd_jenis,
                    'kd_merek'=>$kd_merek,
                    'kd_satuan_stok'=>$kd_satuan,
                    'stok'=>($row[6] != null)?$row[6]:0,
                    'stok_opname'=>($row[7] != null)?$row[7]:0,
                    'stok_minimal'=>($row[8] != null)?$row[8]:0,
                    'stok_maksimal'=>($row[9] != null)?$row[9]:0,
                    
                ]);

                if(isset($row[10]) || isset($row[11])){
                    $harga = [
                        'kd_barang'=>$kd_barang,
                        'kd_satuan_beli'=>$kd_satuan,
                        'jumlah_persatuan_beli'=>1,
                        'jumlah_persatuan_jual'=>1,
                        'beli_isi'=>1,
                        'kd_satuan_jual'=>$kd_satuan,
                        'harga_beli'=>($row[10] != null)?$row[10]:0,
                        'harga_jual'=>($row[11] != null)?$row[11]:0,
                        'diskon'=>0
                    ];
                    HargaBarang::create($harga);
                }
                return $barang;
            }
                
        } else {
            $lb = Barang::orderBy('created_at','desc')->first();
            if(!isset($row[1]) && !isset($row[9]) && (isset($row[10]) || isset($row[11]))){
                $harga = [
                    'kd_barang'=>$lb->kd_barang,
                    'kd_satuan_beli'=>$lb->kd_satuan_stok,
                    'jumlah_persatuan_beli'=>1,
                    'jumlah_persatuan_jual'=>1,
                    'beli_isi'=>1,
                    'kd_satuan_jual'=>$lb->kd_satuan_stok,
                    'harga_beli'=>($row[10] != null)?$row[10]:0,
                    'harga_jual'=>($row[11] != null)?$row[11]:0,
                    'diskon'=>0
                ];
                HargaBarang::create($harga);
            }
        }
    }
}
