<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Level;
use Auth;
use Session;
class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   

        if(!\Helper::cek_akses('User','View')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }
        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = User::where('name','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "User";
        $url = "user";
        $menu = "User";
        $no = 1;
       
        return view('user.index',compact('title','url','menu','no','datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $levels = Level::all();

        $title = "User";
        $url = "user";
        $menu = "User";
        $no = 1;

       
        return view('user.create',compact('title','url','menu','no','levels'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   

        $this->validate($request,[
            'name'=>'required|string',
            'username'=>'required|string',
            'password'=>'required|string',
            'id_level'=>'required|string',
        ]);
        $cek = User::create([
            
            'name'=>$request->name,
            'username'=>$request->username,
            'password' => \Hash::make($request->password),
            'level_id'=>$request->id_level
        ]);
        if($cek){
            \Helper::add_user_log("Menambah Data User ".$request->name);
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Tambah"
            ]);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('user');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $levels = Level::all();
        $data = User::find($id);


        $title = "User";
        $url = "user";
        $menu = "User";
        $no = 1;

       
        return view('user.edit',compact('title','url','menu','no','levels','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {   
        $this->validate($request,[
            'name'=>'required|string',
            'id_level'=>'required|string',
        ]);
        $cek = User::find($id)->update([
            
            'name'=>$request->name,
            'level_id'=>$request->id_level
        ]);
        if($cek){
            \Helper::add_user_log("Mengubah Data User ".$request->name);
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Update"
            ]);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Update"
            ]);
            return redirect()->back();
        }

        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
  
    public function destroy($id)
    {
        $user = User::find($id);
        \Helper::add_user_log("Mengahapus Data User ".$user->name);
        $user->delete();
        return response()->json([
            'success' => 'Record deleted successfully!'
        ]);
    }

    public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        $data = User::whereIn('id',explode(",",$ids));
        \Helper::add_user_log("Mengahapus Beberapa User ");
        $data->delete();
        return response()->json(['success'=>"Data Deleted successfully."]);
    }

    public function ubah_password($id,Request $request)
    {
        $data = User::findOrFail($id);
        $cekpas = password_verify($request->password_lama,$data->password);
        if($cekpas){
            $data->update(['password'=>bcrypt($request->password_baru)]);
            Auth::logout();
            return redirect('/');
        } else {
            Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Silahkan masukan password lama anda dengan benar"
            ]);
            return redirect('/user/'.$id.'/edit');
        }
    }
}
