<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Supplier;
use App\Exports\SupplierExport;
use App\Imports\SupplierImport;
use Maatwebsite\Excel\Facades\Excel;
class SupplierController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   

        if(!\Helper::cek_akses('Supplier','View')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }
        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = Supplier::where('nm_supplier','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "Supplier";
        $url = "supplier";
        $menu = "Master Data";
        $no = 1;
       
        return view('supplier.index',compact('title','url','menu','no','datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = "Supplier";
        $url = "supplier";
        $menu = "Master Data";
        $no = 1;
       
        return view('supplier.create',compact('title','url','menu','no'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $l = Supplier::orderBy('kd_supplier','DESC')->first();
        $kd = "S000";
        if($l){
            $kd = $l->kd_supplier;
        }
        
        $this->validate($request,[
            'nm_supplier'=>'required|string',
            'nm_merek'=>'required|string',
            'alamat'=>'required|string',
            'no_telepon'=>'required|string',
        ]);
        $cek = Supplier::create([
            'kd_supplier'=>++$kd,
            
            'nm_supplier'=>$request->nm_supplier,
            'nm_merek'=>$request->nm_merek,
     
            'alamat'=>$request->alamat,
            'no_telepon'=>$request->no_telepon

        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Tambah"
            ]);
            \Helper::add_user_log("Menambah Data Supplier ".$cek->nm_supplier);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('supplier');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Supplier::find($id);

        $title = "Supplier";
        $url = "supplier";
        $menu = "Master Data";
        $no = 1;
       
        return view('supplier.edit',compact('title','url','menu','no','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {   

        $this->validate($request,[
            'nm_supplier'=>'required|string',
            'alamat'=>'required|string',
            'no_telepon'=>'required|string',
        ]);
        $cek = Supplier::find($id)->update([
            
            'nm_supplier'=>$request->nm_supplier,
            'nm_merek'=>$request->nm_merek,
            'alamat'=>$request->alamat,
            'no_telepon'=>$request->no_telepon

        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Edit"
            ]);
            \Helper::add_user_log("Mengubah Data Spplier ".$cek->nm_supplier);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Edit"
            ]);
            return redirect()->back();
        }

        return redirect('supplier/'.$id.'/edit');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $cek = Supplier::find($id);
        \Helper::add_user_log("Menghapus Data Supplier ".$cek->nm_supplier);
        $cek->delete($id);
        return response()->json([
            'success' => 'Record deleted successfully!'
        ]);
    }

    public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        $data = Supplier::whereIn('kd_supplier',explode(",",$ids));
        $data->delete();
        \Helper::add_user_log("Menghapus Data Supplier");
        return response()->json(['success'=>"Data Deleted successfully."]);
    }


    /**
    * @return \Illuminate\Support\Collection
    */
    public function importExportView()
    {   

        $title = "Import Supplier";
        $url = "supplier";
        $menu = "Master Data";
        $no = 1;
       return view('supplier.import',compact('title','url','menu','no'));
    }
   
    /**
    * @return \Illuminate\Support\Collection
    */
    public function export() 
    {   

        return Excel::download(new SupplierExport, 'suppliers-'.date('Y-m-d H:i').'.xlsx');
    }
   
    /**
    * @return \Illuminate\Support\Collection
    */
    public function import() 
    {
        Excel::import(new SupplierImport,request()->file('file'));
        \Session::flash(
            "flash_notif",[
                "level"   => "dismissible alert-success",
                "massage" => "File Berhasil Di Import"
        ]);

        \Helper::add_user_log("Import Data Supplier Dari Excel");
           
        return redirect()->back();
    }
}
