<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Satuan;
class SatuanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   

        if(!\Helper::cek_akses('Satuan','View')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }
        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = Satuan::where('nm_satuan','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "Satuan";
        $url = "satuan";
        $menu = "Master Data";
        $no = 1;
       
        return view('satuan.index',compact('title','url','menu','no','datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = "Satuan";
        $url = "satuan";
        $menu = "Master Data";
        $no = 1;
       
        return view('satuan.create',compact('title','url','menu','no'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $l = Satuan::orderBy('kd_satuan','DESC')->first();
        $kd = "N000";
        if($l){
            $kd = $l->kd_satuan;
        }
        
        $this->validate($request,[
            'nm_satuan'=>'required|string',
            
        ]);
        $cek = Satuan::create([
            'kd_satuan'=>++$kd,
            'nm_satuan'=>$request->nm_satuan,
        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Tambah"
            ]);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('satuan');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Satuan::find($id);

        $title = "Satuan";
        $url = "satuan";
        $menu = "Master Data";
        $no = 1;
       
        return view('satuan.edit',compact('title','url','menu','no','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {   
        $this->validate($request,[
            'nm_satuan'=>'required|string',
            
        ]);
        $cek = Satuan::find($id)->update([
            
            'nm_satuan'=>$request->nm_satuan,
            

        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Edit"
            ]);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Edit"
            ]);
            return redirect()->back();
        }

        return redirect('satuan/'.$id.'/edit');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Satuan::find($id)->delete($id);
        \Helper::add_user_log("Menghapus Data Satuan");
        return response()->json([
            'success' => 'Record deleted successfully!'
        ]);
    }

    public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        $data = Satuan::whereIn('kd_satuan',explode(",",$ids));
        $data->delete();
        \Helper::add_user_log("Menghapus Data Satuan");
        return response()->json(['success'=>"Data Deleted successfully."]);
    }
}
