<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ReturPenjualan;
use App\DetailReturPenjualan;
use App\Pelanggan;
use App\HargaBarang;
use App\Barang;
use Auth;
class ReturPenjualanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = ReturPenjualan::where('no_retur_penjualan','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "Retur Penjualan";
        $url = "retur_penjualan";
        $menu = "Transaksi";
        $no = 1;
       
        return view('retur_penjualan.index',compact('title','url','menu','no','datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $pelanggans = Pelanggan::all();
        $l = ReturPenjualan::orderBy('no_retur_penjualan','DESC')->first();
        $kd = "RP000000";
        if($l){
            $kd = $l->no_retur_penjualan;
        }

        $title = "Retur Penjualan";
        $url = "retur_penjualan";
        $menu = "Transaksi";
        $no = 1;
       
        return view('retur_penjualan.create',compact('title','url','menu','no','pelanggans','kd'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $l = ReturPenjualan::orderBy('no_retur_penjualan','DESC')->first();
        $kd = "RP000000";
        if($l){
            $kd = $l->no_retur_penjualan;
        }
        $cek = ReturPenjualan::create([
            'no_retur_penjualan'=>++$kd,
            'tgl_retur_penjualan'=>$request->tgl_retur_penjualan,
            'kd_pelanggan'=>$request->kd_pelanggan,
            'keterangan'=>$request->keterangan,
           
            'id_user'=>Auth::user()->id
           
        ]);

        $ih = $request->id_harga_barang;
        $jm = $request->jumlah;
        $ds = $request->diskon;
        $kd = $request->keterangan_detail;
        $harga = [];
        
        for ($i=0; $i < count($ih); $i++) { 
            $harga[] = [
                'no_retur_penjualan'=>$cek->no_retur_penjualan,
                'id_harga_barang'=>$ih[$i],
                'jumlah'=>$jm[$i],
                
                'keterangan'=>$kd[$i]
               
            ];
           
        }


        if($cek){
            $cek2 = DetailReturPenjualan::insert($harga);
            
            if($cek2){
                for ($i=0; $i < count($ih); $i++) { 
                    $hb = HargaBarang::find($ih[$i]);
                    $b = Barang::find($hb->kd_barang);
                    $b->update([
                        'stok'=>$b->stok+($jm[$i]*$hb->jumlah_persatuan_jual)
                    ]);
                }
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-success",
                        "massage" => "Data Berhasil Di Tambah"
                ]);
                \Helper::add_user_log("Menambah data retur penjualan ".$cek->no_retur_penjualan);
            } else {
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-danger",
                        "massage" => "Data Gagal Di Tambah"
                ]);
                ReturPenjualan::find($cek->no_retur_penjualan)->delete();
                return redirect()->back();
            }
            
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('retur_penjualan');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = ReturPenjualan::find($id);
        $pelanggans = Pelanggan::all();
        $title = "Retur Penjualan";
        $url = "retur_penjualan";
        $menu = "Transaksi";
        $no = 1;
       
        return view('retur_penjualan.detail',compact('title','url','menu','no','data','pelanggans'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
        $data = ReturPenjualan::find($id);
        $pelanggans = Pelanggan::all();
        $title = "Retur Penjualan";
        $url = "retur_penjualan";
        $menu = "Transaksi";
        $no = 1;
       
        return view('retur_penjualan.edit',compact('title','url','menu','no','data','pelanggans'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {   
        $cek = ReturPenjualan::find($id);
        $cek->update([
           
            'tgl_retur_penjualan'=>$request->tgl_retur_penjualan,
            'kd_pelanggan'=>$request->kd_pelanggan,
            'keterangan'=>$request->keterangan,
           
            'id_user'=>Auth::user()->id
           
        ]);

        $old_data = [];
        foreach ($cek->detail as $e) {
            $old_data[] = [
                'no_retur_penjualan'=>$cek->no_retur_penjualan,
                'id_harga_barang'=>$e->id_harga_barang,
                'jumlah'=>$e->jumlah,
                'keterangan'=>$e->keterangan
               
            ];
        }

        $ih = $request->id_harga_barang;
        $jm = $request->jumlah;
        $ds = $request->diskon;
        $kd = $request->keterangan_detail;
        $harga = [];
        
        for ($i=0; $i < count($ih); $i++) { 
            $harga[] = [
                'no_retur_penjualan'=>$cek->no_retur_penjualan,
                'id_harga_barang'=>$ih[$i],
                'jumlah'=>$jm[$i],
                
                'keterangan'=>$kd[$i]
               
            ];
           
        }


        if($cek){
            DetailReturPenjualan::where('no_retur_penjualan',$cek->no_retur_penjualan)->delete();
            $cek2 = DetailReturPenjualan::insert($harga);
            
            if($cek2){
                foreach ($cek->detail as $e) {
                    $hb = HargaBarang::find($e->id_harga_barang);
                    $b = Barang::find($hb->kd_barang);
                    $b->update([
                        'stok'=>$b->stok+$e->jumlah
                    ]);
                }
                for ($i=0; $i < count($ih); $i++) { 
                    $hb = HargaBarang::find($ih[$i]);
                    $b = Barang::find($hb->kd_barang);
                    $b->update([
                        'stok'=>$b->stok-$jm[$i]
                    ]);
                }
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-success",
                        "massage" => "Data Berhasil Di Edit"
                ]);
            } else {
                DetailReturPenjualan::insert($old_data);
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-danger",
                        "massage" => "Data Gagal Di Edit"
                ]);
               
                return redirect()->back();
            }
            
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Edit"
            ]);
            return redirect()->back();
        }

        return redirect('retur_penjualan');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   
        DetailReturPenjualan::where('no_retur_penjualan',$id)->delete();
        ReturPenjualan::find($id)->delete();
  
        return response()->json([
            'success' => 'Record deleted successfully!'
        ]);
    }

    public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        DetailReturPenjualan::whereIn('no_retur_penjualan',explode(",",$ids))->delete();
        ReturPenjualan::whereIn('no_retur_penjualan',explode(",",$ids))->delete();
       
        return response()->json(['success'=>"Data Deleted successfully."]);
    }

    public function cetak($id)
    {
        $pelanggans = Pelanggan::all();
        $data = ReturPenjualan::find($id);

        $title = "Retur Penjualan";
        $url = "retur_penjualan";
        $menu = "Transaksi";
        $no = 1;
       
        return view('retur_penjualan.cetak',compact('title','url','menu','no','pelanggans','data'));
    }
}
