<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ReturPembelian;
use App\DetailReturPembelian;
use App\Supplier;
use App\HargaBarang;
use App\Barang;
use Auth;
class ReturPembelianController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = ReturPembelian::where('no_retur_pembelian','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "Retur Pembelian";
        $url = "retur_pembelian";
        $menu = "Transaksi";
        $no = 1;
       
        return view('retur_pembelian.index',compact('title','url','menu','no','datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $suppliers = Supplier::all();
        $l = ReturPembelian::orderBy('no_retur_pembelian','DESC')->first();
        $kd = "RP000000";
        if($l){
            $kd = $l->no_retur_pembelian;
        }

        $title = "Retur Pembelian";
        $url = "retur_pembelian";
        $menu = "Transaksi";
        $no = 1;
       
        return view('retur_pembelian.create',compact('title','url','menu','no','suppliers','kd'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $l = ReturPembelian::orderBy('no_retur_pembelian','DESC')->first();
        $kd = "RP000000";
        if($l){
            $kd = $l->no_retur_pembelian;
        }
        $cek = ReturPembelian::create([
            'no_retur_pembelian'=>++$kd,
            'tgl_retur_pembelian'=>$request->tgl_retur_pembelian,
            'kd_supplier'=>$request->kd_supplier,
            'keterangan'=>$request->keterangan,
           
            'id_user'=>Auth::user()->id
           
        ]);

        $ih = $request->id_harga_barang;
        $jm = $request->jumlah;
        $ds = $request->diskon;
        $kd = $request->keterangan_detail;
        $harga = [];
        
        for ($i=0; $i < count($ih); $i++) { 
            $harga[] = [
                'no_retur_pembelian'=>$cek->no_retur_pembelian,
                'id_harga_barang'=>$ih[$i],
                'jumlah'=>$jm[$i],
                
                'keterangan'=>$kd[$i]
               
            ];
           
        }


        if($cek){
            $cek2 = DetailReturPembelian::insert($harga);
            
            if($cek2){
                for ($i=0; $i < count($ih); $i++) { 
                    $hb = HargaBarang::find($ih[$i]);
                    $b = Barang::find($hb->kd_barang);
                    $b->update([
                        'stok'=>$b->stok-($jm[$i]*$hb->jumlah_persatuan_beli)
                    ]);
                }
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-success",
                        "massage" => "Data Berhasil Di Tambah"
                ]);
                \Helper::add_user_log("Menambah data retur pembelian ".$cek->no_retur_pembelian);
            } else {
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-danger",
                        "massage" => "Data Gagal Di Tambah"
                ]);
               
                return redirect()->back();
            }
            
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('retur_pembelian/'.$cek->no_retur_pembelian);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $suppliers = Supplier::all();
        $data = ReturPembelian::find($id);

        $title = "Retur Pembelian";
        $url = "retur_pembelian";
        $menu = "Transaksi";
        $no = 1;
       
        return view('retur_pembelian.detail',compact('title','url','menu','no','suppliers','data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $suppliers = Supplier::all();
        $data = ReturPembelian::find($id);

        $title = "Retur Pembelian";
        $url = "retur_pembelian";
        $menu = "Transaksi";
        $no = 1;
       
        return view('retur_pembelian.edit',compact('title','url','menu','no','suppliers','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {   

        $cek = ReturPembelian::find($id);
        $cek->update([
           
            'tgl_retur_pembelian'=>$request->tgl_retur_pembelian,
            'kd_supplier'=>$request->kd_supplier,
            'keterangan'=>$request->keterangan,
           
            'id_user'=>Auth::user()->id
           
        ]);

        $old_data = [];
        foreach ($cek->detail as $e) {
            $old_data[] = [
                'no_retur_pembelian'=>$cek->no_retur_pembelian,
                'id_harga_barang'=>$e->id_harga_barang,
                'jumlah'=>$e->jumlah,
                
                'keterangan'=>$e->keterangan
               
            ];
        }

        $ih = $request->id_harga_barang;
        $jm = $request->jumlah;
        $ds = $request->diskon;
        $kd = $request->keterangan_detail;
        $harga = [];
    
        for ($i=0; $i < count($ih); $i++) { 
            $harga[] = [
                'no_retur_pembelian'=>$cek->no_retur_pembelian,
                'id_harga_barang'=>$ih[$i],
                'jumlah'=>$jm[$i],
                
                'keterangan'=>$kd[$i]
               
            ];
           
        }


        if($cek){
            DetailReturPembelian::where('no_retur_pembelian',$cek->no_retur_pembelian)->delete();
            $cek2 = DetailReturPembelian::insert($harga);
            
            if($cek2){
                foreach ($cek->detail as $e) {
                    $hb = HargaBarang::find($e->id_harga_barang);
                    $b = Barang::find($hb->kd_barang);
                    $b->update([
                        'stok'=>$b->stok+$e->jumlah
                    ]);
                }
                for ($i=0; $i < count($ih); $i++) { 
                    $hb = HargaBarang::find($ih[$i]);
                    $b = Barang::find($hb->kd_barang);
                    $b->update([
                        'stok'=>$b->stok-$jm[$i]
                    ]);
                }
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-success",
                        "massage" => "Data Berhasil Di Edit"
                ]);
            } else {
                DetailReturPembelian::insert($old_data);
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-danger",
                        "massage" => "Data Gagal Di Edit"
                ]);
                ReturPembelian::find($cek->no_retur_pembelian)->delete();
                return redirect()->back();
            }
            
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Edit"
            ]);
            return redirect()->back();
        }

        return redirect('retur_pembelian/'.$cek->no_retur_pembelian);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   
        DetailReturPembelian::where('no_retur_pembelian',$id)->delete();
        ReturPembelian::find($id)->delete();
  
        return response()->json([
            'success' => 'Record deleted successfully!'
        ]);
    }

    public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        DetailReturPembelian::whereIn('no_retur_pembelian',explode(",",$ids))->delete();
        ReturPembelian::whereIn('no_retur_pembelian',explode(",",$ids))->delete();
      
        return response()->json(['success'=>"Data Deleted successfully."]);
    }

    public function cetak($id)
    {
        $suppliers = Supplier::all();
        $data = ReturPembelian::find($id);

        $title = "Retur Pembelian";
        $url = "retur_pembelian";
        $menu = "Transaksi";
        $no = 1;
       
        return view('retur_pembelian.cetak',compact('title','url','menu','no','suppliers','data'));
    }
}
