<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Profil;
use App\City;
class ProfilController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
        $data = Profil::all();
        $kota = City::all();
        if(count($data) > 0){
            $data = Profil::all()[0];
        }
        $menu = "Pengaturan";
        $title = "Profil";
        $url = "profil";

        return view('profil.index',compact('menu','title','url','data','kota'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $p = Profil::find(1);
        $logo = $p->logo;
        $logo2 = $p->logo2;


        if($request->hasFile('logo')){
            request()->validate([

                'logo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:5000',

            ]);
            $logo = $request->nama.'.'.request()->logo->getClientOriginalExtension();
            request()->logo->move(public_path('images'), $logo);
        }

        if($request->hasFile('logo2')){
            request()->validate([

                'logo2' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:5000',

            ]);
            $logo2 = $request->nama.'2.'.request()->logo2->getClientOriginalExtension();
            request()->logo2->move(public_path('images'), $logo2);
        }

        

        Profil::find(1)->update([
            'nama'=>$request->nama,
            'alamat'=>$request->alamat,
            'no_telepon'=>$request->no_telepon,
            'keterangan'=>$request->keterangan,
            'city_id'=>$request->kota,
            'logo'=>$logo,
            'logo2'=>$logo2
        ]);
        return redirect('home');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
