<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Penjualan;
use App\DetailPenjualan;
use App\Pelanggan;
use App\Barang;
use App\Profil;
use App\City;
use App\HargaBarang;
use App\Paket;
use App\DetailPaket;
use App\MetodeBayar;
use Auth;
use Kavist\RajaOngkir\Facades\RajaOngkir;
class PenjualanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $s = (isset($_GET['s']))?$_GET['s']:'';

        $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-7 Day'));
        $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');

        $query = Penjualan::where('no_penjualan','like','%'.$s.'%')->orderBy('created_at','DESC')->whereBetween('tgl_penjualan',[$from,$to]);
        
        $datas = $query->paginate(30);

        $all_datas = Penjualan::where('no_penjualan','like','%'.$s.'%')->orderBy('created_at','DESC')->whereBetween('tgl_penjualan',[$from,$to])->get();

        $grand_total_penjualan = 0;
        foreach($all_datas as $data){
            $total_penjualan = 0;

            foreach($data->detail as $detail){
                $harga_diskon = @$detail->jumlah * @$detail->harga_barang->harga_jual - @$detail->diskon;
                $total_penjualan += $harga_diskon;
            }

            $grand_total_penjualan += $total_penjualan;
        }

        
        $datas->appends('s');

        $title = "Penjualan";
        $url = "penjualan";
        $menu = "Master Data";
        $no = 1;

        
       
        return view('penjualan.index',compact('title','url','menu','no','datas','from','to','grand_total_penjualan'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $pelanggans = Pelanggan::all();
        $metode = MetodeBayar::all();
        $pakets = Paket::all();
        // $data = RajaOngkir::kota()->search('Samarind')->get();
        $l = Penjualan::orderBy('no_penjualan','DESC')->first();
        $kd = "P000000";
        if($l){
            $kd = $l->no_penjualan;
        }

        $title = "Penjualan";
        $url = "penjualan";
        $menu = "Master Data";
        $no = 1;
       
        return view('penjualan.create',compact('title','url','menu','no','pelanggans','kd','pakets','metode'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $l = Penjualan::orderBy('no_penjualan','DESC')->first();
        $kd = "P000000";
        if($l){
            $kd = $l->no_penjualan;
        }
        $this->validate($request,[
            'tgl_penjualan'=>'required|date',
            'kd_pelanggan'=>'required|string',
            'keterangan'=>'required|string',
            
        ]);
        
        $cek = Penjualan::create([
            'no_penjualan'=>++$kd,
            'tgl_penjualan'=>$request->tgl_penjualan,
            'kd_pelanggan'=>$request->kd_pelanggan,
            'keterangan'=>$request->keterangan,
            'ket'=>$request->ket,
            'id_user'=>Auth::user()->id,
            'uang_bayar'=>$request->uang_bayar,
            'ongkos_kirim'=>$request->ongkos_kirim,
           
        ]);
        $total = 0;
        $harga_barang = HargaBarang::whereIn('id', $request->id_harga_barang)->get();
        $ih = $request->id_harga_barang;
        $jm = $request->jumlah;
        $ds = $request->diskon;
        
        $harga = [];
        for ($i=0; $i < count($ih); $i++) { 
            $harga[] = [
                'no_penjualan'=>$cek->no_penjualan,
                'id_harga_barang'=>$ih[$i],
                'jumlah'=>$jm[$i],
                'diskon'=>($ds[$i] != null || $ds[$i] != '')?$ds[$i]:0,
            ];
            if(!empty($harga_barang[$i])){
                $total += $harga_barang[$i]->harga_jual;
            }
            
        }

        if($cek){
            // $point = Pelanggan::find($request->kd_pelanggan);
            // $point->update([]);
            // $bagi = \Helper::getBonus()->poin;
            // $point = Pelanggan::find($request->kd_pelanggan);
            // $point->update(['point' => $point->point + ($total / round($bagi,0)) ]);
            $cek2 = DetailPenjualan::insert($harga);
            if($cek2){

                for ($i=0; $i < count($ih); $i++) { 
                    $hb = HargaBarang::find($ih[$i]);
                    $b = Barang::find($hb->kd_barang);
                    $b->update([
                        'stok'=>$b->stok-($jm[$i]*$hb->jumlah_persatuan_jual)
                    ]);
                    
                }
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-success",
                        "massage" => "Data Berhasil Di Tambah"
                ]);
                \Helper::add_user_log("Menambah Data Penjualan ".$cek->no_penjualan);
            } else {
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-danger",
                        "massage" => "Data Gagal Di Tambah"
                ]);
                Penjualan::find($cek->no_penjualan)->delete();
                return redirect()->back();
            }
            
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }
        
        return redirect('penjualan/'.$cek->no_penjualan.'?cetak=true');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $pelanggans = Pelanggan::all();
        $data = Penjualan::find($id);

        $title = "Penjualan";
        $url = "penjualan";
        $menu = "Master Data";
        $no = 1;
        
        return view('penjualan.detail',compact('title','url','menu','no','pelanggans','data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $pelanggans = Pelanggan::all();
        $data = Penjualan::find($id);

        $title = "Penjualan";
        $url = "penjualan";
        $menu = "Master Data";
        $no = 1;
       
        return view('penjualan.edit',compact('title','url','menu','no','pelanggans','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {   
        $cek = Penjualan::find($id);
        $this->validate($request,[
            'tgl_penjualan'=>'required|date',
            'kd_pelanggan'=>'required|string',
            'keterangan'=>'required|string',
            
        ]);
        $cek->update([
           
            'tgl_penjualan'=>$request->tgl_penjualan,
            'kd_pelanggan'=>$request->kd_pelanggan,
            'keterangan'=>$request->keterangan,
            'id_user'=>Auth::user()->id,
            'uang_bayar'=>$request->uang_bayar,
            
           
        ]);

        $old_data = [];
        foreach ($cek->detail as $e) {
            $old_data[] = [
                'no_penjualan'=>$cek->no_penjualan,
                'id_harga_barang'=>$e->id_harga_barang,
                'jumlah'=>$e->jumlah,
                'diskon'=>$e->diskon,
            ];
        }

        $ih = $request->id_harga_barang;
        $jm = $request->jumlah;
        $ds = $request->diskon;

        $harga = [];
        for ($i=0; $i < count($ih); $i++) { 
            $harga[] = [
                'no_penjualan'=>$cek->no_penjualan,
                'id_harga_barang'=>$ih[$i],
                'jumlah'=>$jm[$i],
                'diskon'=>$ds[$i],
            ];
        }

        if($cek){
            DetailPenjualan::where('no_penjualan',$cek->no_penjualan)->delete();
            $cek2 = DetailPenjualan::insert($harga);
            if($cek2){
                foreach ($cek->detail as $e) {
                    $hb = HargaBarang::find($e->id_harga_barang);
                    $b = Barang::find($hb->kd_barang);
                    $b->update([
                        'stok'=>$b->stok+$e->jumlah
                    ]);
                }
                for ($i=0; $i < count($ih); $i++) { 
                    $hb = HargaBarang::find($ih[$i]);
                    $b = Barang::find($hb->kd_barang);
                    if($jm[$i] > $b->stok){
                        \Session::flash(
                            "flash_notif",[
                                "level"   => "dismissible alert-danger",
                                "massage" => "Stok Barang Tidak Cukup"
                        ]);
                        return redirect()->back();
                    }
                    $b->update([
                        'stok'=>$b->stok-$jm[$i]
                    ]);
                }
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-success",
                        "massage" => "Data Berhasil Di Edit"
                ]);
                \Helper::add_user_log("Mengubah Data Penjualan ".$cek->no_penjualan);
            } else {
                 DetailPenjualan::insert($old_data);
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-danger",
                        "massage" => "Data Gagal Di Edit"
                ]);
                
                return redirect()->back();
            }
            
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Edit"
            ]);
            return redirect()->back();
        }

        return redirect('penjualan/'.$cek->no_penjualan);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   
        $cek = Penjualan::find($id);
        foreach ($cek->detail as $e) {
            $hb = HargaBarang::find($e->id_harga_barang);
            $b = Barang::find($hb->kd_barang);
            // if($b->stok_minimal > $b->stok+$cek->jumlah){
            //     return response()->json([
            //         'error' => 'Ops!!! Data Tidak Bisa Di Hapus.jika dihapus stok barang melewati basat minimal'
            //     ]);
            // }
            $b->update([
                'stok'=>$b->stok+$e->jumlah
            ]);

        }
        DetailPenjualan::where('no_penjualan',$id)->delete();
    
        Penjualan::where('no_penjualan',$id)->delete();
        \Helper::add_user_log("Mengahapus Data Penjualan ".$id);
        return response()->json(['success'=>"Data Deleted successfully."]);
    }

    public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        
        $data = Penjualan::whereIn('no_penjualan',explode(",",$ids))->get();
        foreach ($data as $cek) {
            foreach ($cek->detail as $e) {
                $hb = HargaBarang::find($e->id_harga_barang);
                $b = Barang::find($hb->kd_barang);
                // if($b->stok_minimal > $b->stok+$cek->jumlah){
                //     return response()->json([
                //         'error' => 'Ops!!! Data Tidak Bisa Di Hapus.jika dihapus stok barang melewati basat minimal'
                //     ]);
                // }
                $b->update([
                    'stok'=>$b->stok+$e->jumlah
                ]);

            }
        }
        DetailPenjualan::whereIn('no_penjualan',explode(",",$ids))->delete();
        Penjualan::whereIn('no_penjualan',explode(",",$ids))->delete();
        \Helper::add_user_log("Mengahapus ".count(explode(",",$ids))." Data Penjualan ");
        return response()->json(['success'=>"Data Deleted successfully."]);
    }

    public function cetak($id)
    {
        $pelanggans = Pelanggan::all();
        $data = Penjualan::find($id);
        $profil = Profil::first();
        $title = "Penjualan";
        $url = "penjualan";
        $menu = "Master Data";
        $no = 1;
       
        return view('penjualan.cetak',compact('title','url','menu','no','pelanggans','data', 'profil'));
    }

    public function cetakThermal($id)
    {
        $pelanggans = Pelanggan::all();
        $data = Penjualan::find($id);
        $profil = Profil::first();
        $title = "Penjualan";
        $url = "penjualan";
        $menu = "Master Data";
        $no = 1;
       
        return view('penjualan.cetak-thermal',compact('title','url','menu','no','pelanggans','data', 'profil'));
    }
}
