<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Pembelian;
use App\DetailPembelian;
use App\Supplier;
use App\HargaBarang;
use App\Barang;
use App\MetodeBayar;
use Auth;
use App\Profil;

class PembelianController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = Pembelian::where('no_pembelian','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "Pembelian";
        $url = "pembelian";
        $menu = "Master Data";
        $no = 1;
       
        return view('pembelian.index',compact('title','url','menu','no','datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $suppliers = Supplier::all();
        $metode = MetodeBayar::all();
        $l = Pembelian::orderBy('no_pembelian','DESC')->first();
        $kd = "P000000";
        if($l){
            $kd = $l->no_pembelian;
        }

        $title = "Pembelian";
        $url = "pembelian";
        $menu = "Master Data";
        $no = 1;
       
        return view('pembelian.create',compact('title','url','menu','no','suppliers','kd','metode'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $l = Pembelian::orderBy('no_pembelian','DESC')->first();
        $kd = "P000000";
        if($l){
            $kd = $l->no_pembelian;
        }
        $this->validate($request,[
            'tgl_pembelian'=>'required|date',
            'kd_supplier'=>'required|string',
            'keterangan'=>'required|string',
            'dp'=>'required|numeric',
        ]);
        $cek = Pembelian::create([
            'no_pembelian'=>++$kd,
            'tgl_pembelian'=>$request->tgl_pembelian,
            'kd_supplier'=>$request->kd_supplier,
            'keterangan'=>$request->keterangan,
            'dp'=>$request->dp,
            'id_user'=>Auth::user()->id,
            'ppn'=>(isset($request->ppn))?1:0,
           
        ]);

        $ih = $request->id_harga_barang;
        $jm = $request->jumlah;
        $ds = $request->diskon;
        $harga_baru = $request->harga_baru;
        $harga_jual = $request->harga_jual;
        $jenis_harga = $request->jenis_harga;

        $harga = [];
        
        for ($i=0; $i < count($ih); $i++) { 
            
            $hb = HargaBarang::find($ih[$i]);
          
            if($jenis_harga[$i] != "tidak"){
                if($jenis_harga[$i] == "update"){
                    $hb->update([
                        'harga_beli'=>$harga_baru[$i],
                        'harga_jual'=>$harga_jual[$i],
                    ]);
                } else {
                    $hh = HargaBarang::create([
                        'kd_barang'=>$hb->kd_barang,
                        'kd_satuan_beli'=>$hb->kd_satuan_beli,
                        'beli_isi'=>$jm[$i],
                        'kd_satuan_jual'=>$hb->kd_satuan_jual,
                        'harga_beli'=>$harga_baru[$i],
                        'harga_jual'=>$harga_jual[$i],
                        'diskon'=>$ds[$i]
                    ]);
                    $ih[$i] = $hh->id;
                }
            }

         
           
        }

        for ($i=0; $i < count($ih); $i++) { 
            
            
            $harga[] = [
                'no_pembelian'=>$cek->no_pembelian,
                'id_harga_barang'=>$ih[$i],
                'jumlah'=>$jm[$i],
                'diskon'=>$ds[$i],
               
            ];
           
        }


        if($cek){
            $cek2 = DetailPembelian::insert($harga);
            
            if($cek2){
                for ($i=0; $i < count($ih); $i++) { 
                    $hb = HargaBarang::find($ih[$i]);
                    $b = Barang::find($hb->kd_barang);

                    $b->update([
                        'stok'=>$b->stok+($jm[$i]*$hb->jumlah_persatuan_beli)
                    ]);
                }
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-success",
                        "massage" => "Data Berhasil Di Tambah"
                ]);
                \Helper::add_user_log("Menambah Data Pembelian ".$cek->no_pembelian);
            } else {
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-danger",
                        "massage" => "Data Gagal Di Tambah"
                ]);
                Pembelian::find($cek->no_pembelian)->delete();
                return redirect()->back();
            }
            
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('pembelian/'.$kd);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $suppliers = Supplier::all();
        $data = Pembelian::find($id);

        $title = "Pembelian";
        $url = "pembelian";
        $menu = "Master Data";
        $no = 1;
       
        return view('pembelian.detail',compact('title','url','menu','no','suppliers','data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
        $suppliers = Supplier::all();
        $data = Pembelian::find($id);

        $title = "Pembelian";
        $url = "pembelian";
        $menu = "Master Data";
        $no = 1;
       
        return view('pembelian.edit',compact('title','url','menu','no','suppliers','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $cek = Pembelian::find($id);
        $cek->update([
            
            'tgl_pembelian'=>$request->tgl_pembelian,
            'kd_supplier'=>$request->kd_supplier,
            'keterangan'=>$request->keterangan,
            'dp'=>$request->dp,
            'id_user'=>Auth::user()->id
           
        ]);

        $old_data = [];
        $old_stok = [];
        foreach ($cek->detail as $e) {
            
            $old_data[] = [
                'no_pembelian'=>$cek->no_pembelian,
                'id_harga_barang'=>$e->id_harga_barang,
                'jumlah'=>$e->jumlah,
                'diskon'=>$e->diskon,
               
            ];

        }

        $ih = $request->id_harga_barang;
        $jm = $request->jumlah;
        $ds = $request->diskon;

        $harga = [];
        
        for ($i=0; $i < count($ih); $i++) { 
            $harga[] = [
                'no_pembelian'=>$cek->no_pembelian,
                'id_harga_barang'=>$ih[$i],
                'jumlah'=>$jm[$i],
                'diskon'=>$ds[$i],
               
            ];
           
        }


        if($cek){
            DetailPembelian::where('no_pembelian',$cek->no_pembelian)->delete();
            $cek2 = DetailPembelian::insert($harga);
            
            if($cek2){
                foreach ($cek->detail as $e) {
                    $hb = HargaBarang::find($e->id_harga_barang);
                    $b = Barang::find($hb->kd_barang);
                    $b->update([
                        'stok'=>$b->stok-$e->jumlah
                    ]);

                }
                for ($i=0; $i < count($ih); $i++) { 
                    $hb = HargaBarang::find($ih[$i]);
                    $b = Barang::find($hb->kd_barang);
                    $b->update([
                        'stok'=>$b->stok+$jm[$i]
                    ]);
                }
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-success",
                        "massage" => "Data Berhasil Di Edit"
                ]);
                \Helper::add_user_log("Mengubah Data Pembelian ".$cek->no_pembelian);
            } else {
                DetailPembelian::insert($old_data);
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-danger",
                        "massage" => "Data Gagal Di Edit"
                ]);
               
                return redirect()->back();
            }
            
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Edit"
            ]);
            return redirect()->back();
        }

        return redirect('pembelian/'.$cek->no_pembelian);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $cek = Pembelian::find($id);
        foreach ($cek->detail as $e) {
            $hb = HargaBarang::find($e->id_harga_barang);
            $b = Barang::find($hb->kd_barang);
            if($b->stok_minimal > $b->stok-$e->jumlah){
                return response()->json([
                    'error' => 'Ops!!! Data '.$cek->no_pembelian.' Tidak Bisa Di Hapus.jika dihapus stok barang melewati batas minimal'
                ]);
            }
            $b->update([
                'stok'=>$b->stok-$e->jumlah
            ]);

        }
        DetailPembelian::where('no_pembelian',$id)->delete();
        $cek2 = Pembelian::find($id);
        $cek2->delete();
        \Helper::add_user_log("Menghapus Data Pembelian ".$id);
        
        return response()->json([
            'success' => 'Data Berhasil Di Hapus!'
        ]);
    }

    public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        $data = Pembelian::whereIn('no_pembelian',explode(",",$ids))->get();
        foreach ($data as $cek) {
            foreach ($cek->detail as $e) {
                $hb = HargaBarang::find($e->id_harga_barang);
                $b = Barang::find($hb->kd_barang);
                if($b->stok_minimal > $b->stok-$e->jumlah){
                    return response()->json([
                        'error' => 'Ops!!! Data '.$cek->no_pembelian.' Tidak Bisa Di Hapus.jika dihapus stok barang melewati batas minimal'
                    ]);
                }
                $b->update([
                    'stok'=>$b->stok-$e->jumlah
                ]);

            }
        }
        DetailPembelian::whereIn('no_pembelian',explode(",",$ids))->delete();
        Pembelian::whereIn('no_pembelian',explode(",",$ids))->delete();
        \Helper::add_user_log("Menghapus ".count(explode(",",$ids))." Data Pembelian ");
        return response()->json(['success'=>"Data Deleted successfully."]);
    }

    public function cetak($id)
    {
        $suppliers = Supplier::all();
        $data = Pembelian::find($id);

        $profil = Profil::first();
        $title = "Pembelian";
        $url = "pembelian";
        $menu = "Master Data";
        $no = 1;
       
        return view('pembelian.cetak',compact('title','url','menu','no','suppliers','data', 'profil'));
    }
}
