<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Pelanggan;
use App\City;
use App\Exports\PelangganExport;
use App\Imports\PelangganImport;
use Maatwebsite\Excel\Facades\Excel;
use Kavist\RajaOngkir\Facades\RajaOngkir;
use Auth;
use Artisan;
class PelangganController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   

        if(!\Helper::cek_akses('Pelanggan','View')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }

        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = Pelanggan::where('nm_pelanggan','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "Pelanggan";
        $url = "pelanggan";
        $menu = "Master Data";
        $no = 0;
       
        return view('pelanggan.index',compact('title','url','menu','no','datas'));
    }


    public function kota()
    {
     
     $datas = Pelanggan::where('kd_pelanggan','like','%'.$_GET['id'].'%')->first();
     // dd($datas->city_id);
     $idTo = $datas->city_id;
     $idFrom = \Helper::get_kota()->city_id;
     // dd($idFrom);

     $harga = RajaOngkir::ongkosKirim([
    'origin'        => $idFrom,     // ID kota/kabupaten asal
    'destination'   => $idTo,      // ID kota/kabupaten tujuan
    'weight'        => $_GET['berat'],    // berat barang dalam gram
    'courier'       => 'jne'    // kode kurir pengiriman: 
    ])->get();

     // dd($harga[0]['costs'][1]['cost'][0]['value']);
     //$h = $harga[0]['costs'][1]['cost'];
     if (isset($_GET['layanan'])) {
         if ($_GET['layanan'] == 'reguler') {
             $h = $harga[0]['costs'][0]['cost'];
         } elseif ($_GET['layanan'] == 'cepat'){
            $h = $harga[0]['costs'][1]['cost'];
         } elseif ($_GET['layanan'] == 'express'){
            $h = $harga[0]['costs'][2]['cost'];
        } else{
            $h = $harga[0]['costs'][0]['cost'];
        }
     }else {$h = $harga[0]['costs'][0]['cost'];}

     return view('pelanggan.get_pelanggan',compact('h'));   
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        if(!\Helper::cek_akses('Pelanggan','Add')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }
        $data = City::orderBy('title', 'asc')->get();
        $title = "Pelanggan";
        $url = "pelanggan";
        $menu = "Master Data";
        $no = 1;

        return view('pelanggan.create',compact('title','url','menu','no','data'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $l = Pelanggan::orderBy('kd_pelanggan','DESC')->first();
        $kd = "P000";
        if($l){
            $kd = $l->kd_pelanggan;
        }
        
        $cek = Pelanggan::create([
            'kd_pelanggan'=>++$kd,
            'nm_pelanggan'=>$request->nm_pelanggan,
            
            'alamat'=>$request->alamat,
            'no_telepon'=>$request->no_telepon,
            'city_id'=>$request->kota,
            'status'=>$request->status
        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Tambah"
            ]);
            \Helper::add_user_log("Menambah Data Pelanggan ".$cek->nm_pelanggan);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('pelanggan');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   

        if(!\Helper::cek_akses('Pelanggan','Edit')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }
        $data = Pelanggan::find($id);
        $kota = City::all();

        $title = "Pelanggan";
        $url = "pelanggan";
        $menu = "Master Data";
        $no = 1;
       
        return view('pelanggan.edit',compact('title','url','menu','no','data','kota'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $cek = Pelanggan::find($id)->update([

            'nm_pelanggan'=>$request->nm_pelanggan,
            'city_id'=>$request->kota,
            'alamat'=>$request->alamat,
            'no_telepon'=>$request->no_telepon

        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Edit"
            ]);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Edit"
            ]);
            return redirect()->back();
        }

        return redirect('pelanggan/'.$id.'/edit');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   

        if(!\Helper::cek_akses('Pelanggan','Delete')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }
        Pelanggan::find($id)->delete($id);
  
        return response()->json([
            'success' => 'Record deleted successfully!'
        ]);
    }

    public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        $data = Pelanggan::whereIn('kd_pelanggan',explode(",",$ids));
        $data->delete();
        return response()->json(['success'=>"Data Deleted successfully."]);
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function importExportView()
    {   

        $title = "Import Pelanggan";
        $url = "pelanggan";
        $menu = "Master Data";
        $no = 1;
       return view('pelanggan.import',compact('title','url','menu','no'));
    }
   
    /**
    * @return \Illuminate\Support\Collection
    */
    public function export() 
    {   

        return Excel::download(new PelangganExport, 'pelanggans-'.date('Y-m-d H:i').'.xlsx');
    }
   
    /**
    * @return \Illuminate\Support\Collection
    */
    public function import() 
    {
        Excel::import(new PelangganImport,request()->file('file'));
        \Session::flash(
            "flash_notif",[
                "level"   => "dismissible alert-success",
                "massage" => "File Berhasil Di Import"
        ]);

        \Helper::add_user_log("Import Data Pelanggan Dari Excel");
           
        return redirect()->back();
    }
}
