<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Paket;
use App\DetailPaket;
use App\Barang;


class PaketController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = Paket::paginate(10);
        

        $title = "Paket";
        $url = "paket";
        $menu = "Master Data";
        $no = 1;


        return view('paket.index', compact('datas','url','menu','no','title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = "Paket";
        $url = "paket";
        $menu = "Master Data";
        return view('paket.create', compact('title','url','menu'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $insert = Paket::create([
            'nama_paket' => $request->no_penjualan,
            'harga' => $request->uang_bayar,
        ]);

        $id = $insert->id;
        $ih = $request->id_harga_barang;

        $detail = [];
        for ($i=0; $i < count($ih); $i++){
            $detail[] = [
                'id_paket'=>$id,
                'kd_barang'=>$ih[$i],
            ];
        }

        if ($insert) {
            $insert2 = DetailPaket::insert($detail);
            if ($insert2) {
                return redirect()->back();
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $delete = Paket::where('id_paket',$id);
        $delete->delete();
        \Helper::add_user_log("Menghapus Data Paket ".$id);
        return response()->json([
            'success' => 'Record deleted successfully!'
        ]);
    }
}
