<?php

namespace App\Http\Controllers;

use App\MetodeBayar;
use Illuminate\Http\Request;

class MetodeBayarController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $datas = MetodeBayar::all();

        $title = "Metode Bayar";
        $url = "metode_bayar";
        $menu = "Master Data";
        $no = 1;

        return view('metode_bayar.index', compact('title','url','menu','datas','no'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         

        $title = "Metode Bayar";
        $url = "metode_bayar";
        $menu = "Master Data";

        return view('metode_bayar.create', compact('title','url','menu'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $cek = MetodeBayar::create([
                "metode"=>$request->metode,
                "keterangan"=>$request->keterangan
        ]);
         if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Tambah"
            ]);
            \Helper::add_user_log("menambah Data Metode ".$cek->metode);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('metode_bayar');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\MetodeBayar  $metodeBayar
     * @return \Illuminate\Http\Response
     */
    public function show(MetodeBayar $metodeBayar)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\MetodeBayar  $metodeBayar
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
         $data = MetodeBayar::find($id);

        $title = "Metode Bayar";
        $url = "metode_bayar";
        $menu = "Master Data";
        $no = 1;
       
        return view('metode_bayar.edit',compact('title','url','menu','no','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\MetodeBayar  $metodeBayar
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $cek = MetodeBayar::find($id)->update([
            
            "metode"=>$request->metode,
            "keterangan"=>$request->keterangan
            

        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Edit"
            ]);
            // \Helper::add_user_log("Mengedit Data Metode Bayar ".$cek->metode);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Edit"
            ]);
            return redirect()->back();
        }

        return redirect('metode_bayar/'.$id.'/edit');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\MetodeBayar  $metodeBayar
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
         try {
            
            MetodeBayar::find($id)->delete($id);
            \Helper::add_user_log("Menghapus Data Metode");
           
        } catch (\Illuminate\Database\QueryException $e) {
            if($e->errorInfo[1] == 1451){
                return response()->json([
                    'error' => 'Data Masih Digunakan'
                ]);
            }  
        }
  
        return response()->json([
            'success' => 'Record deleted successfully!'
        ]);
    }

      public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        $data = MetodeBayar::whereIn('kd_kategori',explode(",",$ids));
        $data->delete();
        \Helper::add_user_log("Menghapus Data Metode");
        return response()->json(['success'=>"Data Deleted successfully."]);
    }
}
