<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Merek;
class MerekController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   

        if(!\Helper::cek_akses('Merek','View')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }
        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = Merek::where('nm_merek','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "Merek";
        $url = "merek";
        $menu = "Master Data";
        $no = 1;
       
        return view('merek.index',compact('title','url','menu','no','datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = "Merek";
        $url = "merek";
        $menu = "Master Data";
        $no = 1;
       
        return view('merek.create',compact('title','url','menu','no'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $l = Merek::orderBy('kd_merek','DESC')->first();
        $kd = "M000";
        if($l){
            $kd = $l->kd_merek;
        }
        $this->validate($request,[
            'nm_merek'=>'required|string',
            
            
        ]);
        
        $cek = Merek::create([
            'kd_merek'=>++$kd,
            'nm_merek'=>$request->nm_merek,
        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Tambah"
            ]);
            \Helper::add_user_log("Menambah Data Merek ".$cek->nm_merek);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('merek');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Merek::find($id);

        $title = "Merek";
        $url = "merek";
        $menu = "Master Data";
        $no = 1;
       
        return view('merek.edit',compact('title','url','menu','no','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {   

        $this->validate($request,[
            'nm_merek'=>'required|string',
            
            
        ]);
        $cek = Merek::find($id)->update([
            
            'nm_merek'=>$request->nm_merek,
            

        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Edit"
            ]);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Edit"
            ]);
            return redirect()->back();
        }

        return redirect('merek/'.$id.'/edit');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   

        try {
            
            Merek::find($id)->delete($id);
            \Helper::add_user_log("Menghapus Data Merek");
           
        } catch (\Illuminate\Database\QueryException $e) {
            if($e->errorInfo[1] == 1451){
                return response()->json([
                    'error' => 'Data Masih Digunakan'
                ]);
            }  
        }
        
  
        return response()->json([
            'success' => 'Record deleted successfully!'
        ]);
    }

    public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        $data = Merek::whereIn('kd_merek',explode(",",$ids));
        $data->delete();
        \Helper::add_user_log("Menghapus Data Merek");
        return response()->json(['success'=>"Data Deleted successfully."]);
    }
}
