<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Level;
use App\Menu;
class LevelController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   

        if(!\Helper::cek_akses('Level','View')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }
        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = Level::where('nm_level','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "Level";
        $url = "level";
        $menu = "Master Data";
        $no = 1;
       
        return view('level.index',compact('title','url','menu','no','datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $menus = Menu::all();

        $title = "Level";
        $url = "level";
        $menu = "Master Data";
        $no = 1;
       
        return view('level.create',compact('title','url','menu','no','menus'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      
        
        $cek = Level::create([
           
            'nm_level'=>$request->nm_level,
        ]);
        if($cek){

            $menu = [];
            if(isset($request->id_menu)){
                for ($i=0; $i < count($request->id_menu); $i++) { 
                    $menu [] = ['menu_id'=>$request->id_menu[$i]];
                }
            }
                

            $cek->level_menu()->attach($menu);
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Tambah"
            ]);
            \Helper::add_user_log("Menambah Data Level ".$cek->nm_level);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('level');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
        $menus = Menu::all();
        $data = Level::find($id);

        $title = "Level";
        $url = "level";
        $menu = "Master Data";
        $no = 1;
       
        return view('level.edit',compact('title','url','menu','no','data','menus'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {   


        $lu = Level::find($id);
            
        $menu = [];
        if($request->id_menu == null){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Silahkan Pilih Minimal Satu Menu"
            ]);
            return redirect()->back();
        }
        for ($i=0; $i < count($request->id_menu); $i++) { 
            $menu [] = ['menu_id'=>$request->id_menu[$i]];
        }

        $lu->level_menu()->sync([]);
        $lu->level_menu()->attach($menu);
        // $lu->level_menu()->sync($menu);
        $cek = Level::find($id)->update([
            
            'nm_level'=>$request->nm_level,
            

        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Edit"
            ]);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Edit"
            ]);
            return redirect()->back();
        }

        return redirect('level/'.$id.'/edit');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   
        if(LevelMenu::where('level_id',$id)->count() > 0){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Hapus <br> Data masih digunakan"
            ]);
            return redirect()->back();
        }

        if(User::where('level_id',$id)->count() > 0){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Hapus <br> Data masih digunakan"
            ]);
            return redirect()->back();
        }
        Level::find($id)->delete();
  
        return response()->json([
            'success' => 'Record deleted successfully!'
        ]);
    }

    public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        $data = Level::whereIn('id',explode(",",$ids));
        $data->delete();
        return response()->json(['success'=>"Data Deleted successfully."]);
    }
}
