<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\User;
use App\Jenis;
use App\Satuan;
use App\Supplier;
use App\Pelanggan;
use App\Merek;
use App\Kategori;
use App\Barang;
use App\Penjualan;
use App\Pembelian;
use App\ReturPembelian;
use App\ReturPenjualan;
use App\DetailPenjualan;
use App\Jasa;
use App\DetailJasa;
class LaporanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {   

        $menu = "Laporan";
        $title = str_replace('_', ' ', $id);
        $url = "laporan/";
        $view = "laporan.".$id;
        $datas = array();
        $datas2 = array();
        $user = null;
        $seconds =array();
        $url .= $id;

        if(!isset($_GET['menu'])){
            $view .= '.index';
        } else {
            switch ($_GET['menu']) {
                case 'user':
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $datas = User::where('name','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "User";
                break;
                case 'supplier':
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $datas = Supplier::where('nm_supplier','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Supplier";
                break;
                case 'pelanggan':
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $datas = Pelanggan::where('nm_pelanggan','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Pelanggan";
                break;
                case 'merek':
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $datas = Merek::where('nm_merek','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Merek";
                break;

                case 'kategori':
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $datas = Kategori::where('nm_kategori','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Kategori";
                break;
                case 'barang_kategori':
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $g = (isset($_GET['kd_kategori']))?$_GET['kd_kategori']:'';
                $datas = Barang::where('nm_barang','like','%'.$s.'%')->whereHas('jenis',function ($j) use($g)
                {
                    $j->whereHas('kategori',function ($k) use($g)
                    {
                        $k->where('kd_kategori','like','%'.$g.'%');
                    });
                })->orderBy('created_at','DESC')->paginate(10);
                $seconds = Kategori::all();
                $datas->appends($_GET);

                $view .= '.'.$_GET['menu'];
                $title = "Barang Per Kategori";
                break;
                case 'barang_periode':
                    $s = (isset($_GET['s']))?$_GET['s']:'';
                    $kd_jenis = isset($_GET['kd_jenis'])?$_GET['kd_jenis']:'';
                    $kd_merek = isset($_GET['kd_merek'])?$_GET['kd_merek']:'';

                    $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                    $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                    if(isset($_GET['from']) && isset($_GET['periode'])){
                        $datas = Barang::where(function ($q)use($s)
                        {
                            $q->where('nm_barang','like','%'.$s.'%')->orWhere('barcode','like','%'.$s.'%');
                        })
                        ->where('kd_jenis','like','%'.$kd_jenis.'%')->where('kd_merek','like','%'.$kd_merek.'%')
                        ->whereHas('harga_barang',function ($hb)  use($from,$to)
                        {
                            $hb->whereHas('detail_penjualan',function ($dp)  use($from,$to)
                            {
                                $dp->whereHas('penjualan',function ($p) use($from,$to)
                                {
                                    $p->whereBetween('tgl_penjualan',[$from,$to]);
                                });
                            });
                        })->orderBy('nm_barang','ASC')->get();
                    } else {
                        $datas = Barang::where(function ($q)use($s)
                        {
                            $q->where('nm_barang','like','%'.$s.'%')->orWhere('barcode','like','%'.$s.'%');
                        })
                        ->where('kd_jenis','like','%'.$kd_jenis.'%')->where('kd_merek','like','%'.$kd_merek.'%')->orderBy('created_at','DESC')->get();
                    }
                    //$datas->appends($_GET);
                    $view .= '.'.$_GET['menu'];
                    $title = "Barang Per Periode";

                break;
                case 'pembelian':
                $g = (isset($_GET['kd_supplier']))?$_GET['kd_supplier']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                $datas = Pembelian::where('no_pembelian','like','%'.$s.'%')->where('kd_supplier','like','%'.$g.'%')->orderBy('created_at','DESC')->whereBetween('tgl_pembelian',[$from,$to])->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Pembelian";
                $seconds = Supplier::all();
                break;
                case 'penjualan':
                $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                $datas = Penjualan::where('no_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereBetween('tgl_penjualan',[$from,$to])->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Penjualan";
                $seconds = Pelanggan::all();
                break;
                case 'penjualan_barang':
                $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                $datas = Penjualan::where('no_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereBetween('tgl_penjualan',[$from,$to])->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Penjualan Per Barang";
                $seconds = Pelanggan::all();
                break;
                case 'penjualan_pelanggan':
                $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                $datas = Penjualan::where('no_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereBetween('tgl_penjualan',[$from,$to])->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Penjualan Per Pelanggan";
                $seconds = Pelanggan::all();
                break;
                
                case 'penjualan_kasir':
                $daterange = explode(' - ', (isset($_GET['daterange']))?$_GET['daterange']:date('Y-m-d H:i',strtotime('-1 Month')).' - '.date('Y-m-d H:i'));
                $s = (isset($_GET['s']))?$_GET['s']:'';
                
                $from = date('Y-m-d H:i:s',strtotime($daterange[0]));
                $to =    date('Y-m-d H:i:s',strtotime($daterange[1]));
                $datas = DetailPenjualan::with('penjualan')->whereHas('penjualan',function ($p) use($from,$to)
                {
                    $p->whereBetween('created_at',[$from,$to]);
                })->get();
                if(isset($_GET['user_id']) && $_GET['user_id'] != '' && isset($_GET['metode']) && $_GET['metode'] != ''){
                    $datas = DetailPenjualan::with('penjualan')->whereHas('penjualan',function ($p) use($from,$to)
                    {
                        $p->whereBetween('created_at',[$from,$to])->where('id_user',$_GET['user_id'])->where('keterangan', $_GET['metode']);
                    })->get();
                } else if(isset($_GET['user_id']) && $_GET['user_id'] == '' && isset($_GET['metode']) && $_GET['metode'] != ''){
                    $datas = DetailPenjualan::with('penjualan')->whereHas('penjualan',function ($p) use($from,$to)
                    {
                        $p->whereBetween('created_at',[$from,$to])->where('keterangan', $_GET['metode']);
                    })->get();
                }
                    
               
                // $datas->appends($_GET);

                $view .= '.'.$_GET['menu'];
                $title = "Penjualan Per Kasir";
                $seconds = User::all();
                break;
                
                case 'penjualan_terlaris':
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                $datas = Barang::whereHas('harga_barang',function ($hb)  use($from,$to)
                {
                    $hb->whereHas('detail_penjualan',function ($dp)  use($from,$to)
                    {
                        $dp->whereHas('penjualan',function ($p) use($from,$to)
                        {
                            $p->whereBetween('tgl_penjualan',[$from,$to]);
                        });
                    });
                })->where('nm_barang','like','%'.$s.'%')->paginate(10);
                $datas->appends($_GET);
                $datas->sortByDesc('qty');
                $view .= '.'.$_GET['menu'];
                $title = "Penjualan Barang Terlaris";
                break;
                case 'penjualan_bulan':
                $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';

                $bulan = (isset($_GET['bulan']))?$_GET['bulan']:date('m');
                $tahun =   (isset($_GET['tahun']))?$_GET['tahun']:date('Y');
                if($bulan != "00"){
                    $datas = Penjualan::where('no_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereMonth('created_at',$bulan)->whereYear('created_at',$tahun)->paginate(10);
                } else {
                    $datas = Penjualan::where('no_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereYear('created_at',$tahun)->paginate(10);
                }
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Penjualan Per Bulan & Tahun";
                $seconds = Pelanggan::all();
                break;
                case 'penjualan_keseluruhan':
                $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                $datas = Penjualan::where('no_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereBetween('tgl_penjualan',[$from,$to])->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Penjualan Keseluruhan";
                $seconds = Pelanggan::all();
                break;
                case 'retur_periode':
                $g = (isset($_GET['kd_supplier']))?$_GET['kd_supplier']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                $datas = ReturPembelian::where('no_retur_pembelian','like','%'.$s.'%')->where('kd_supplier','like','%'.$g.'%')->orderBy('created_at','DESC')->whereBetween('tgl_retur_pembelian',[$from,$to])->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Retur Pembelian Periode";
                $seconds = Supplier::all();
                break;
                case 'retur_bulan':
                $g = (isset($_GET['kd_supplier']))?$_GET['kd_supplier']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $bulan = (isset($_GET['bulan']))?$_GET['bulan']:date('m');
                $tahun =   (isset($_GET['tahun']))?$_GET['tahun']:date('Y');
                if($bulan != "00"){
                    $datas = ReturPembelian::where('no_retur_pembelian','like','%'.$s.'%')->where('kd_supplier','like','%'.$g.'%')->orderBy('created_at','DESC')->whereMonth('tgl_retur_pembelian',$bulan)->whereYear('tgl_retur_pembelian',$tahun)->paginate(10);
                } else {
                    $datas = ReturPembelian::where('no_retur_pembelian','like','%'.$s.'%')->where('kd_supplier','like','%'.$g.'%')->orderBy('created_at','DESC')->whereYear('tgl_retur_pembelian',$tahun)->paginate(10);
                }

                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Retur Pembelian Per Bulan & Tahun";
                $seconds = Supplier::all();
                break;
                case 'retur_barang_periode':
                $g = (isset($_GET['kd_supplier']))?$_GET['kd_supplier']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');

                $datas = ReturPembelian::where('no_retur_pembelian','like','%'.$s.'%')->where('kd_supplier','like','%'.$g.'%')->orderBy('created_at','DESC')->whereBetween('tgl_retur_pembelian',[$from,$to])->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Retur Pembelian Barang Periode";
                $seconds = Supplier::all();
                break;
                case 'retur_barang_bulan':
                $g = (isset($_GET['kd_supplier']))?$_GET['kd_supplier']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $bulan = (isset($_GET['bulan']))?$_GET['bulan']:date('m');
                $tahun =   (isset($_GET['tahun']))?$_GET['tahun']:date('Y');
                if($bulan != "00"){
                    $datas = ReturPembelian::where('no_retur_pembelian','like','%'.$s.'%')->where('kd_supplier','like','%'.$g.'%')->orderBy('created_at','DESC')->whereMonth('tgl_retur_pembelian',$bulan)->whereYear('tgl_retur_pembelian',$tahun)->paginate(10);
                } else {
                    $datas = ReturPembelian::where('no_retur_pembelian','like','%'.$s.'%')->where('kd_supplier','like','%'.$g.'%')->orderBy('created_at','DESC')->whereYear('tgl_retur_pembelian',$tahun)->paginate(10);
                }
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Retur Pembelian Barang Per Bulan & Tahun";
                $seconds = Supplier::all();
                break;
                case 'rekap_retur_periode':
                $g = (isset($_GET['kd_supplier']))?$_GET['kd_supplier']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                $datas = ReturPembelian::where('no_retur_pembelian','like','%'.$s.'%')->where('kd_supplier','like','%'.$g.'%')->orderBy('created_at','DESC')->whereBetween('tgl_retur_pembelian',[$from,$to])->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Rekap Retur Pembelian Periode";
                $seconds = Supplier::all();
                break;
                case 'rekap_retur_bulan':
                $g = (isset($_GET['kd_supplier']))?$_GET['kd_supplier']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $bulan = (isset($_GET['bulan']))?$_GET['bulan']:date('m');
                $tahun =   (isset($_GET['tahun']))?$_GET['tahun']:date('Y');
                if($bulan != "00"){
                    $datas = ReturPembelian::where('no_retur_pembelian','like','%'.$s.'%')->where('kd_supplier','like','%'.$g.'%')->orderBy('created_at','DESC')->whereMonth('tgl_retur_pembelian',$bulan)->whereYear('tgl_retur_pembelian',$tahun)->paginate(10);
                } else {
                    $datas = ReturPembelian::where('no_retur_pembelian','like','%'.$s.'%')->where('kd_supplier','like','%'.$g.'%')->orderBy('created_at','DESC')->whereYear('tgl_retur_pembelian',$tahun)->paginate(10);
                }
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Retur Pembelian";
                $seconds = Supplier::all();
                break;
                case 'retur_jual_periode':
                $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                $datas = ReturPenjualan::where('no_retur_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereBetween('tgl_retur_penjualan',[$from,$to])->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Retur Penjualan Periode";
                $seconds = Pelanggan::all();
                break;
                case 'retur_jual_bulan':
                $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $bulan = (isset($_GET['bulan']))?$_GET['bulan']:date('m');
                $tahun =   (isset($_GET['tahun']))?$_GET['tahun']:date('Y');
                if($bulan != "00"){
                    $datas = ReturPenjualan::where('no_retur_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereMonth('tgl_retur_pembelian',$bulan)->whereYear('tgl_retur_pembelian',$tahun)->paginate(10);
                } else {
                    $datas = ReturPenjualan::where('no_retur_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereYear('tgl_retur_pembelian',$tahun)->paginate(10);
                }
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Retur Penjualan Per Bulan & Tahun";
                $seconds = Pelanggan::all();
                break;
                case 'retur_jual_barang_periode':
                $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                $datas = ReturPenjualan::where('no_retur_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereBetween('tgl_retur_penjualan',[$from,$to])->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Retur Penjualan Barang Periode";
                $seconds = Pelanggan::all();
                break;
                case 'retur_jual_barang_bulan':
                $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $bulan = (isset($_GET['bulan']))?$_GET['bulan']:date('m');
                $tahun =   (isset($_GET['tahun']))?$_GET['tahun']:date('Y');
                if($bulan != "00"){
                    $datas = ReturPenjualan::where('no_retur_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereMonth('tgl_retur_pembelian',$bulan)->whereYear('tgl_retur_pembelian',$tahun)->paginate(10);
                } else {
                    $datas = ReturPenjualan::where('no_retur_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereYear('tgl_retur_pembelian',$tahun)->paginate(10);
                }
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Retur Penjualan Barang Per Bulan & Tahun";
                $seconds = Pelanggan::all();
                break;
                case 'rekap_retur_jual_periode':
                $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                $datas = ReturPenjualan::where('no_retur_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereBetween('tgl_retur_penjualan',[$from,$to])->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Rekap Retur Penjualan Per Periode";
                $seconds = Pelanggan::all();
                break;
                case 'rekap_retur_jual_bulan':
                $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $bulan = (isset($_GET['bulan']))?$_GET['bulan']:date('m');
                $tahun =   (isset($_GET['tahun']))?$_GET['tahun']:date('Y');
                $datas = ReturPenjualan::where('no_retur_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereMonth('tgl_retur_penjualan',$bulan)->whereYear('tgl_retur_penjualan',$tahun)->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Rakap Retur Penjualan Per Bulan & Tahun";
                $seconds = Pelanggan::all();
                break;
                // baru penjualan barang /user
                case 'penjualan_barang_user':
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $user_id = (isset($_GET['user_id']));

                if ($user_id && $_GET['user_id'] !== '') {
                    $user = User::find($_GET['user_id']);
                    $datas = User::where('name','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
                } else {
                    $datas = User::where('name','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
                }

                $datas->appends('s','menu', 'user_id');
                $view .= '.'.$_GET['menu'];
                $title = "Penjualan Per Kasir";
                break;
                
                case 'jasa_kasir':
                $g = (isset($_GET['user']))?$_GET['user']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                $datas = DetailJasa::with('jasa_root')->whereHas('jasa_root',function ($p) use($from,$to)
                {
                     $g = (isset($_GET['user']))?$_GET['user']:'';
                    $p->whereBetween('created_at',[$from,$to." 23:59:59"])->where('user_id','like','%'.$g.'%');
                })->paginate(10);

                $datas->appends($_GET);

                $view .= '.'.$_GET['menu'];
                $title = "Jasa Per Kasir";
                $seconds = User::all();
                break;

                case 'jasa_periode':
                $g = (isset($_GET['no_jasa']))?$_GET['no_jasa']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                $datas = DetailJasa::where('no_jasa','like','%'.$g.'%')->whereBetween('created_at',[$from,$to." 23:59:59"])->paginate(10);
                $datas->appends($_GET);
                $view .= '.'.$_GET['menu'];
                $title = "Jasa per Periode";
                $seconds = DetailJasa::all();
                break;

                default:
                    # code...
                break;
            }
            
        }
        $jeniss = Jenis::all();
        $mereks = Merek::all();
        $satuans = Satuan::all();
        return view($view,compact('menu','title','url','datas','seconds', 'datas2', 'user','mereks','jeniss','satuans'));
    }

    public function cetak($m,Request $request)
    {   
        \Helper::add_user_log("Membuat laporan ".$_GET['menu']);
        if($_GET['type'] == "excel"){
            header("Content-type: application/octet-stream");
            header("Content-disposition:attachment;filename=Laporan_".$_GET['menu'].".xls");
        } else {
            echo '<img src="'.url("images/btn_print.png").'" height="20" onClick="javascript:window.print()" />';
        }
        $datas = array();

        $user_id = ''; // baru

        switch ($_GET['menu']) {
            case 'user':

            $datas = User::all();

            break;
            case 'supplier':

            $datas = Supplier::all();

            break;
            case 'pelanggan':

            $datas = Pelanggan::all();

            break;
            case 'merek':

            $datas = Merek::all();

            break;
            case 'kategori':

            $datas = Kategori::all();

            break;
            case 'barang_kategori':
            $g = (isset($_GET['kd_kategori']))?$_GET['kd_kategori']:'';
            $datas = Barang::whereHas('jenis',function ($j) use($g)
            {
                $j->whereHas('kategori',function ($k) use($g)
                {
                    $k->where('kd_kategori','like','%'.$g.'%');
                });
            })->get();
            break;
            case 'barang_periode':

            if(isset($_GET['periode']) && $_GET['periode'] != '' && isset($_GET['from'])){
                $datas = Barang::whereHas('harga_barang',function ($hb)
                {
                    $hb->whereHas('detail_penjualan',function ($dp)
                    {
                        $dp->whereHas('penjualan',function ($p)
                        {
                            $p->whereBetween('tgl_penjualan',[$_GET['from'],$_GET['to']]);
                        });
                    });
                })->get();
            } else {
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $kd_jenis = isset($_GET['kd_jenis'])?$_GET['kd_jenis']:'';
                $kd_merek = isset($_GET['kd_merek'])?$_GET['kd_merek']:'';
                $datas = Barang::where(function ($q)use($s)
                                        {
                                            $q->where('nm_barang','like','%'.$s.'%')->orWhere('barcode','like','%'.$s.'%');
                                        })
                                        ->where('kd_jenis','like','%'.$kd_jenis.'%')->where('kd_merek','like','%'.$kd_merek.'%')->orderBy('created_at','DESC')->get();
            }
                
            break;
            case 'pembelian':
            $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
            $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
            $datas = Pembelian::whereBetween('tgl_pembelian',[$from,$to])->get();

            break;
            case 'penjualan':

            $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
            $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
            $datas = Penjualan::whereBetween('tgl_penjualan',[$from,$to])->orderBy('created_at','DESC')->get();
				

            break;
            case 'penjualan_barang':
            $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
            $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
            $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
            $datas = Penjualan::whereBetween('tgl_penjualan',[$from,$to])->where('kd_pelanggan','like','%'.$g.'%')->get();

            break;
            case 'penjualan_pelanggan':
            $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
            $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
            $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
            $datas = Penjualan::whereBetween('tgl_penjualan',[$from,$to])->where('kd_pelanggan','like','%'.$g.'%')->get();
            break;
            case 'penjualan_kasir':

            $daterange = explode(' - ', (isset($_GET['daterange']))?$_GET['daterange']:date('Y-m-d H:i',strtotime('-1 Month')).' - '.date('Y-m-d H:i'));
            $s = (isset($_GET['s']))?$_GET['s']:'';
            
            $from = date('Y-m-d H:i:s',strtotime($daterange[0]));
            $to =    date('Y-m-d H:i:s',strtotime($daterange[1]));

            $datas = DetailPenjualan::with('penjualan')->whereHas('penjualan',function ($p) use($from,$to)
            {
                $p->whereBetween('created_at',[$from,$to]);
            })->get();

            if(isset($_GET['user_id']) && $_GET['user_id'] != ''){
                $datas = DetailPenjualan::with('penjualan')->whereHas('penjualan',function ($p) use($from,$to)
                {
                    $p->whereBetween('created_at',[$from,$to])->where('id_user',$_GET['user_id']);
                })->get();
            }
             // $datas = Penjualan::where('no_penjualan','like','%'.$s.'%')->orderBy('created_at','DESC')->whereBetween('tgl_penjualan',[$from,$to])->get();
            


            break;
            case 'penjualan_terlaris':

            $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
            $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
            $datas = Barang::whereHas('harga_barang',function ($hb)  use($from,$to)
            {
                $hb->whereHas('detail_penjualan',function ($dp)  use($from,$to)
                {
                    $dp->whereHas('penjualan',function ($p) use($from,$to)
                    {
                        $p->whereBetween('tgl_penjualan',[$from,$to]);
                    });
                });
            })->get();

            $datas->sortByDesc('qty');
            break;

            case 'penjualan_keseluruhan':
            $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';
                $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
                $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
                $datas = Penjualan::where('no_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereBetween('tgl_penjualan',[$from,$to])->get();
              
            break;

            case 'penjualan_bulan' :
             $g = (isset($_GET['kd_pelanggan']))?$_GET['kd_pelanggan']:'';
                $s = (isset($_GET['s']))?$_GET['s']:'';

                $bulan = (isset($_GET['bulan']))?$_GET['bulan']:date('m');
                $tahun =   (isset($_GET['tahun']))?$_GET['tahun']:date('Y');
                if($bulan != "00"){
                    $datas = Penjualan::where('no_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereMonth('created_at',$bulan)->whereYear('created_at',$tahun)->get();
                } else {
                    $datas = Penjualan::where('no_penjualan','like','%'.$s.'%')->where('kd_pelanggan','like','%'.$g.'%')->orderBy('created_at','DESC')->whereYear('created_at',$tahun)->get();
                }
            break;

            case 'retur_periode':
            $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
            $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
            $datas = ReturPembelian::whereBetween('tgl_retur_pembelian',[$from,$to])->get();

            break;
            case 'retur_bulan':
            $bulan = (isset($_GET['bulan']))?$_GET['bulan']:date('m');
            $tahun =   (isset($_GET['tahun']))?$_GET['tahun']:date('Y');

            if($bulan != "00"){
                $datas = ReturPembelian::whereMonth('tgl_retur_pembelian',$bulan)->whereYear('tgl_retur_pembelian',$tahun)->get();
            } else {
                $datas = ReturPembelian::whereYear('tgl_retur_pembelian',$tahun)->get();
            }


            break;
            case 'retur_barang_periode':
            $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
            $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
            $datas = ReturPembelian::whereBetween('tgl_retur_pembelian',[$from,$to])->get();

            break;
            case 'retur_barang_bulan':
            $bulan = (isset($_GET['bulan']))?$_GET['bulan']:date('m');
            $tahun =   (isset($_GET['tahun']))?$_GET['tahun']:date('Y');

            if($bulan != "00"){
                $datas = ReturPembelian::whereMonth('tgl_retur_pembelian',$bulan)->whereYear('tgl_retur_pembelian',$tahun)->get();
            } else {
                $datas = ReturPembelian::whereYear('tgl_retur_pembelian',$tahun)->get();
            }
            break;
            case 'rekap_retur_periode':
            $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
            $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
            $datas = ReturPembelian::whereBetween('tgl_retur_pembelian',[$from,$to])->get();


            break;
            case 'rekap_retur_bulan':
            $bulan = (isset($_GET['bulan']))?$_GET['bulan']:date('m');
            $tahun =   (isset($_GET['tahun']))?$_GET['tahun']:date('Y');

            if($bulan != "00"){
                $datas = ReturPembelian::whereMonth('tgl_retur_pembelian',$bulan)->whereYear('tgl_retur_pembelian',$tahun)->get();
            } else {
                $datas = ReturPembelian::whereYear('tgl_retur_pembelian',$tahun)->get();
            }


            break;
            case 'retur_jual_periode':

            $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
            $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
            $datas = ReturPenjualan::whereBetween('tgl_retur_penjualan',[$from,$to])->orderBy('created_at','DESC')->get();

            break;

            case 'retur_jual_bulan':

            $bulan = (isset($_GET['bulan']))?$_GET['bulan']:date('m');
            $tahun =   (isset($_GET['tahun']))?$_GET['tahun']:date('Y');

            if($bulan != "00"){
                $datas = ReturPenjualan::whereMonth('tgl_retur_penjualan',$bulan)->whereYear('tgl_retur_penjualan',$tahun)->get();
            } else {
                $datas = ReturPenjualan::whereYear('tgl_retur_penjualan',$tahun)->get();
            }

            break;
            case 'retur_jual_barang_periode':

            $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
            $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
            $datas = ReturPenjualan::whereBetween('tgl_retur_penjualan',[$from,$to])->orderBy('created_at','DESC')->get();

            break;
            case 'retur_jual_barang_bulan':

            $bulan = (isset($_GET['bulan']))?$_GET['bulan']:date('m');
            $tahun =   (isset($_GET['tahun']))?$_GET['tahun']:date('Y');

            if($bulan != "00"){
                $datas = ReturPenjualan::whereMonth('tgl_retur_penjualan',$bulan)->whereYear('tgl_retur_penjualan',$tahun)->get();
            } else {
                $datas = ReturPenjualan::whereYear('tgl_retur_penjualan',$tahun)->get();
            }

            break;
            case 'rekap_retur_jual_periode':

            $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
            $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
            $datas = ReturPenjualan::whereBetween('tgl_retur_penjualan',[$from,$to])->orderBy('created_at','DESC')->get();

            break;
            case 'rekap_retur_jual_bulan':

            $bulan = (isset($_GET['bulan']))?$_GET['bulan']:date('m');
            $tahun =   (isset($_GET['tahun']))?$_GET['tahun']:date('Y');

            if($bulan != "00"){
                $datas = ReturPenjualan::whereMonth('tgl_retur_penjualan',$bulan)->whereYear('tgl_retur_penjualan',$tahun)->get();
            } else {
                $datas = ReturPenjualan::whereYear('tgl_retur_penjualan',$tahun)->get();
            }

            break;

            // penjualan barang user
            case 'penjualan_barang_user':
            if (isset($_GET['user_id']) && $_GET['user_id'] !== '') {
                $user_id = $_GET['user_id'];
                $datas = User::find($_GET['user_id']);
            } else {
                $datas = User::whereHas('penjualan',function ($p)
                {
                    $p->whereBetween('tgl_penjualan',[$_GET['from'],$_GET['to']]);
                })->get()->sortByDesc('qty');
            }

            break;
            case 'jasa_kasir':
            $g = (isset($_GET['user']))?$_GET['user']:'';
            $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
            $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
            $datas = DetailJasa::with('jasa_root')->whereHas('jasa_root',function ($p) use($from,$to)
            {
                $g = (isset($_GET['user']))?$_GET['user']:'';
                $p->whereBetween('created_at',[$from,$to." 23:59:59"])->where('user_id','like','%'.$g.'%');
            })->get();


            break;

            case 'jasa_periode':
            $from = (isset($_GET['from']))?$_GET['from']:date('Y-m-d',strtotime('-1 Month'));
            $to =   (isset($_GET['to']))?$_GET['to']:date('Y-m-d');
            $datas = DetailJasa::whereBetween('created_at',[$from,$to." 23:59:59"])->get();

            break;

            default:
                # code...
            break;
        }
        return view('laporan.'.$m.'.cetak_'.$_GET['menu'],compact('datas', 'user_id'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
