<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Kategori;
class KategoriController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   

        if(!\Helper::cek_akses('Kategori','View')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }
        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = Kategori::where('nm_kategori','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "Kategori";
        $url = "kategori";
        $menu = "Master Data";
        $no = 1;
       
        return view('kategori.index',compact('title','url','menu','no','datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = "Kategori";
        $url = "kategori";
        $menu = "Master Data";
        $no = 1;
       
        return view('kategori.create',compact('title','url','menu','no'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $l = Kategori::orderBy('kd_kategori','DESC')->first();
        $kd = "K000";
        if($l){
            $kd = $l->kd_kategori;
        }
        
        $this->validate($request,[
            'nm_kategori'=>'required|string',
            
            
        ]);
        $cek = Kategori::create([
            'kd_kategori'=>++$kd,
            'nm_kategori'=>$request->nm_kategori,
        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Tambah"
            ]);
            \Helper::add_user_log("menambah Data Kategori ".$cek->nm_kategori);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('kategori');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Kategori::find($id);

        $title = "Kategori";
        $url = "kategori";
        $menu = "Master Data";
        $no = 1;
       
        return view('kategori.edit',compact('title','url','menu','no','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {   

        $this->validate($request,[
            'nm_kategori'=>'required|string',
            
            
        ]);
        $cek = Kategori::find($id)->update([
            
            'nm_kategori'=>$request->nm_kategori,
            

        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Edit"
            ]);
            \Helper::add_user_log("Mengedit Data kategori ".$cek->nm_kategori);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Edit"
            ]);
            return redirect()->back();
        }

        return redirect('kategori/'.$id.'/edit');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            
            Kategori::find($id)->delete($id);
            \Helper::add_user_log("Menghapus Data Kategori");
           
        } catch (\Illuminate\Database\QueryException $e) {
            if($e->errorInfo[1] == 1451){
                return response()->json([
                    'error' => 'Data Masih Digunakan'
                ]);
            }  
        }
  
        return response()->json([
            'success' => 'Record deleted successfully!'
        ]);
    }

    public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        $data = Kategori::whereIn('kd_kategori',explode(",",$ids));
        $data->delete();
        \Helper::add_user_log("Menghapus Data Kategori");
        return response()->json(['success'=>"Data Deleted successfully."]);
    }
}
