<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Jenis;
use App\Kategori;
class JenisController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   

        if(!\Helper::cek_akses('Jenis','View')){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Anda Tidak Memiliki Akses"
            ]);

            return redirect('/');
        }
        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = Jenis::where('nm_jenis','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "Jenis";
        $url = "jenis";
        $menu = "Master Data";
        $no = 1;
       
        return view('jenis.index',compact('title','url','menu','no','datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   

        $kategoris = Kategori::all();
        $title = "Jenis";
        $url = "jenis";
        $menu = "Master Data";
        $no = 1;
       
        return view('jenis.create',compact('title','url','menu','no','kategoris'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $l = Jenis::orderBy('kd_jenis','DESC')->first();
        $kd = "K000";
        if($l){
            $kd = $l->kd_jenis;
        }
        
        $this->validate($request,[
            'nm_jenis'=>'required|string',
            'kd_kategori'=>'required|string',
            
        ]);
        $cek = Jenis::create([
            'kd_jenis'=>++$kd,
            'nm_jenis'=>$request->nm_jenis,
            'kd_kategori'=>$request->kd_kategori
        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Tambah"
            ]);
            \Helper::add_user_log("Menambah Data Jenis ".$cek->nm_jenis);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }

        return redirect('jenis');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Jenis::find($id);
        $kategoris = Kategori::all();

        $title = "Jenis";
        $url = "jenis";
        $menu = "Master Data";
        $no = 1;
       
        return view('jenis.edit',compact('title','url','menu','no','data','kategoris'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {           
        $this->validate($request,[
            'nm_jenis'=>'required|string',
            'kd_kategori'=>'required|string',
            
        ]);
        $cek = Jenis::find($id)->update([            
            'nm_jenis'=>$request->nm_jenis,
            'kd_kategori'=>$request->kd_kategori
        ]);
        if($cek){
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-success",
                    "massage" => "Data Berhasil Di Edit"
            ]);
            \Helper::add_user_log("Mengedit Data Jenis ".$request->nm_jenis);
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Edit"
            ]);
            return redirect()->back();
        }

        return redirect('jenis/'.$id.'/edit');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $cek = Jenis::find($id);

        try {
            $cek->delete($id);
            \Helper::add_user_log("Menghapus Data Jenis ".$cek->nm_jenis);
           
        } catch (\Illuminate\Database\QueryException $e) {
            if($e->errorInfo[1] == 1451){
                return response()->json([
                    'error' => 'Data Masih Digunakan'
                ]);
            }  
        }
        return response()->json([
            'success' => 'Record deleted successfully!'
        ]);
    }

    public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        $data = Jenis::whereIn('kd_jenis',explode(",",$ids));
        $data->delete();
        \Helper::add_user_log("Menghapus Data Jenis");
        return response()->json(['success'=>"Data Deleted successfully."]);
    }
}
