<?php

namespace App\Http\Controllers;

use App\Jasa;
use App\Profil;
use App\Pelanggan;
use App\DetailJasa;
use Illuminate\Http\Request;
use Auth;
use App\BayarJasa;
class JasaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = Jasa::where('no_jasa','like','%'.$s.'%')->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "Trasaksi Jasa";
        $url = "jasa";
        $menu = "Jasa";
        $no = 1;
       
        return view('jasa.index',compact('title','url','menu','no','datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $pelanggans = Pelanggan::all();
        $l = Jasa::orderBy('no_jasa','DESC')->first();
        $kd = "J000000";
        if($l){
            $kd = $l->no_jasa;
        }

        $title = "Jasa";
        $url = "jasa";
        $menu = "Master Data";
        $no = 1;
       
        return view('jasa.create',compact('title','url','menu','no','pelanggans','kd'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $l = Jasa::orderBy('no_jasa','DESC')->first();
        $kd = "J000000";
        if($l){
            $kd = $l->no_jasa;
        }
        $this->validate($request,[
            'tgl_jasa'=>'required|date',
            'nama_pelanggan'=>'required|string',
            'pembayaran'=>'required|string',
            
        ]);
        
        $cek = Jasa::create([
            'no_jasa'=>++$kd,
            'tgl_jasa'=>$request->tgl_jasa,
            'nama_pelanggan'=>$request->nama_pelanggan,
            'no_hp_pelanggan'=>$request->no_hp_pelanggan,
            'pembayaran'=>$request->pembayaran,
            'keterangan'=>$request->filled('keterangan') ? $request->get('keterangan') : '',
            'user_id'=>Auth::user()->id,
            'uang_bayar'=>$request->uang_bayar,
            
           
        ]);

        $js = $request->jasa;
        $jm = $request->harga;
        $ds = $request->diskon;
        $qty = $request->qty;

        $harga = [];
        for ($i=0; $i < count($js); $i++) { 
            $harga[] = [
                'no_jasa'=>$cek->no_jasa,
                'jasa'=>$js[$i],
                'harga'=>$jm[$i],
                'qty'=>$qty[$i],
                'diskon'=>($ds[$i] != null || $ds[$i] != '')?$ds[$i]:0,
            ];
        }

        if($cek){
            $cek2 = DetailJasa::insert($harga);
            if($cek2){
                
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-success",
                        "massage" => "Data Berhasil Di Tambah"
                ]);
                \Helper::add_user_log("Menambah Data Jasa ".$cek->no_jasa);
            } else {
                \Session::flash(
                    "flash_notif",[
                        "level"   => "dismissible alert-danger",
                        "massage" => "Data Gagal Di Tambah"
                ]);
                Jasa::find($cek->no_jasa)->delete();
                return redirect()->back();
            }
            
        } else {
            \Session::flash(
                "flash_notif",[
                    "level"   => "dismissible alert-danger",
                    "massage" => "Data Gagal Di Tambah"
            ]);
            return redirect()->back();
        }
        
        return redirect('jasa/'.$cek->no_jasa.'?cetak=true');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Jasa  $jasa
     * @return \Illuminate\Http\Response
     */
    public function show(Jasa $jasa)
    {
        $pelanggans = Pelanggan::all();
        $data = $jasa;

        $title = "Jasa";
        $url = "jasa";
        $menu = "Transaksi Jasa";
        $no = 1;
        
        return view('jasa.detail',compact('title','url','menu','no','pelanggans','data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Jasa  $jasa
     * @return \Illuminate\Http\Response
     */
    public function edit(Jasa $jasa)
    {
        $pelanggans = Pelanggan::all();
        $data = $jasa;

        $title = "Jasa";
        $url = "jasa";
        $menu = "Transaksi Jasa";
        $no = 1;
        
        return view('jasa.edit',compact('title','url','menu','no','pelanggans','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Jasa  $jasa
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Jasa $jasa)
    {
        $jasa->update([
            'tgl_jasa'=>$request->tgl_jasa,
            'nama_pelanggan'=>$request->nama_pelanggan,
            'no_hp_pelanggan'=>$request->no_hp_pelanggan,
            'pembayaran'=>$request->pembayaran,
            // 'keterangan'=>$request->status,
            'status'=>$request->status,
        ]);

        \Session::flash(
            "flash_notif",[
                "level"   => "dismissible alert-success",
                "massage" => "Data Berhasil Di Ubah"
        ]);
        \Helper::add_user_log("Mengubah Data Jasa ".$jasa->no_jasa);

        return redirect('jasa');
            
           
    }

    public function destroy($id)
    {   
        $cek = Jasa::find($id);
        
        DetailJasa::where('no_jasa',$id)->delete();
    
        Jasa::where('no_jasa',$id)->delete();
        \Helper::add_user_log("Mengahapus Data Jasa ".$id);
        return response()->json(['success'=>"Data Deleted successfully."]);
    }

    public function deleteAll(Request $request)
    {
        $ids = $request->ids;
        
       
        DetailJasa::whereIn('no_jasa',explode(",",$ids))->delete();
        Jasa::whereIn('no_jasa',explode(",",$ids))->delete();
        \Helper::add_user_log("Mengahapus ".count(explode(",",$ids))." Data Jasa ");
        return response()->json(['success'=>"Data Deleted successfully."]);
    }

    public function cetak($id)
    {
        $pelanggans = Pelanggan::all();
        $data = Jasa::find($id);
        $profil = Profil::first();
        $title = "Jasa";
        $url = "jasa";
        $menu = "Master Data";
        $no = 1;
       
        return view('jasa.cetak',compact('title','url','menu','no','pelanggans','data', 'profil'));
    }

    public function bayarView()
    {
        $s = (isset($_GET['s']))?$_GET['s']:'';
        $datas = Jasa::where('no_jasa','like','%'.$s.'%')->where('pembayaran','Kredit')->orWhere('pembayaran','Transfer Kredit')->orderBy('created_at','DESC')->paginate(10);
        $datas->appends('s');

        $title = "Bayar Jasa";
        $url = "jasa";
        $menu = "Jasa";
        $no = 1;
       
        return view('jasa.bayar-jasa',compact('title','url','menu','no','datas'));
    }

    public function bayarDetail($no)
    {
        
        $data = Jasa::find($no);

        $title = "Jasa";
        $url = "jasa/".$no."/bayar";
        $menu = "Transaksi Jasa";
        $no = 1;
        
        return view('jasa.bayar-jasa-detail',compact('title','url','menu','no','data'));
    }

    public function bayar(Request $request,$no)
    {   
        $l = BayarJasa::orderBy('no_bayar_jasa','DESC')->first();
        $kd = "BJ000000";
        if($l){
            $kd = $l->no_bayar_jasa;
        }
        BayarJasa::create([
            'no_bayar_jasa'=>++$kd,
            'tgl_bayar_jasa'=>$request->tgl_bayar_jasa,
            'no_jasa'=>$no,
            'user_id'=>Auth::user()->id,
            'uang_bayar'=>$request->uang_bayar,
        ]);

        return redirect('jasa/bayar');
    }

    public function bayarCetak($id)
    {
        
        $data = Jasa::find($id);
        $profil = Profil::first();
        $title = "Jasa";
        $url = "jasa";
        $menu = "Master Data";
        $no = 1;
       
        return view('jasa.bayar-jasa-cetak',compact('title','url','menu','no','data', 'profil'));
    }
}
